package com.pica.cloud.account.account.server.util;


import com.alibaba.fastjson.JSONObject;
import com.pica.cloud.account.account.server.entity.AesBean.AesAuthCodeReq;
import com.pica.cloud.account.account.server.entity.EncryptEntity;
import com.pica.cloud.account.account.server.req.BaseRequest;
import com.pica.cloud.account.account.server.req.OneClickLoginReq;
import org.apache.tomcat.util.codec.binary.Base64;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

import javax.annotation.PostConstruct;
import javax.crypto.Cipher;
import java.io.ByteArrayOutputStream;
import java.security.*;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.HashMap;
import java.util.Map;

/**
 * RSA加解密工具类
 */
@Component
public class RSAUtil {
    private static Map<Integer, String> keyMap = new HashMap<>();

    public static String rsaprivatekey;

    public static String rsapublickey;

    @Value("${rsaprivatekey}")
    public String rsaprivatekeyTemp;
    @Value("${rsapublickey}")
    public String rsapublickeyTemp;

    @PostConstruct
    public void init() {
        RSAUtil.rsaprivatekey = rsaprivatekeyTemp;
        RSAUtil.rsapublickey = rsapublickeyTemp;

        // prd 配置
//        RSAUtil.rsapublickey="MIGfMA0GCSqGSIb3DQEBAQUAA4GNADCBiQKBgQCnVzDlG6DJBwTsn7jFriKOmzqfm+d4vy6DtKqMfrEPg6hU3bfbR9XRfwqAFrS4+QowybpuyWCa7DFyKl0JyEa/GSrfjbXSpalFHhmWH0z0hCF1m/UvlPA0BaiYFy9ucXF9Uh8RaHkZGVmV+RbVISk4pjlZdRcK5EQ5hciBFGtgGwIDAQAB";
//        RSAUtil.rsaprivatekey = "MIICeAIBADANBgkqhkiG9w0BAQEFAASCAmIwggJeAgEAAoGBAKdXMOUboMkHBOyfuMWuIo6bOp+b53i/LoO0qox+sQ+DqFTdt9tH1dF/CoAWtLj5CjDJum7JYJrsMXIqXQnIRr8ZKt+NtdKlqUUeGZYfTPSEIXWb9S+U8DQFqJgXL25xcX1SHxFoeRkZWZX5FtUhKTimOVl1FwrkRDmFyIEUa2AbAgMBAAECgYEAlEZHxtoiL74OePRVrqNLb3zQBxkHkxAj0QPGktK3ZP3Nq9UB0kTmisi8rx5vZ+8TPoOgtAWvmdZrQbOT2NUjCUYKkGS+Wi1fXpP0Az2UJwDIQK4aQTZtNbM04f3Rmi5i24eASmSdl1svjHEv0YS6IC6sR1cbElZs94uDFshUeqECQQDTrmZda8fo6ZNsHVYWcjTwr8JKTIgjaD/hPi0JP6hhL0GVEAVwb2rsfJf5o2TR5RsNT8ANUYgFPRaAymLLe+5zAkEAymA9V55K6IJhnSp7HmWfGVmxvTrwZFJIzPv7DLi/RAS3yFPfTpyJGLirAnBQfKO/vwjxhAuwD21aDYHMTrj1uQJBAJdAikw+cz1tiLU70QOA32sLaxyDytLh7qMXNj7hiYLHrWjBZeGM+y23aTArHCMOPWIpleTuWO7FU4r7EdSr3RkCQQCliu4CwyhRY33H210U81memgFLYnAMEEce7qxgrqs+T4Gqa/lJy8BVqZGxkAA2xJfwA7fUJN9i7zdvvxJJ/wB5AkA+OKfnTXTp8qF4lZiVMrGl3d5sgg87q1DhC5XruviH6a3u6JOLlRNQy2+TGxzWMYaJ1RwEfygqBYOgyvoqNR3Q";

    }

    /**
     * 加密算法RSA
     */
    public static final String KEY_ALGORITHM = "RSA";

    /**
     * RSA最大加密明文大小
     */
    private static final int MAX_ENCRYPT_BLOCK = 117;

    /**
     * RSA最大解密密文大小
     */
    private static final int MAX_DECRYPT_BLOCK = 128;

    /**
     * 加密方法
     *
     * @param keyString
     * @return
     */
    public static String encrypt(String keyString) throws Exception {
        return encrypt(keyString, rsapublickey);
    }

    /**
     * 解密方法
     *
     * @param key
     * @return
     */
    public static String decrypt(String key) throws Exception {
        return decrypt(key, rsaprivatekey);
    }

    /**
     * 随机生成密钥对
     *
     * @throws NoSuchAlgorithmException
     */
    public static void genKeyPair() throws NoSuchAlgorithmException {
        // KeyPairGenerator类用于生成公钥和私钥对，基于RSA算法生成对象
        KeyPairGenerator keyPairGen = KeyPairGenerator.getInstance("RSA");
        // 初始化密钥对生成器，密钥大小为96-1024位
        keyPairGen.initialize(1024, new SecureRandom());
        // 生成一个密钥对，保存在keyPair中
        KeyPair keyPair = keyPairGen.generateKeyPair();
        RSAPrivateKey privateKey = (RSAPrivateKey) keyPair.getPrivate();   // 得到私钥
        RSAPublicKey publicKey = (RSAPublicKey) keyPair.getPublic();  // 得到公钥
        String publicKeyString = new String(Base64.encodeBase64(publicKey.getEncoded()));
        // 得到私钥字符串
        String privateKeyString = new String(Base64.encodeBase64((privateKey.getEncoded())));
        // 将公钥和私钥保存到Map
        keyMap.put(0, publicKeyString);  //0表示公钥
        keyMap.put(1, privateKeyString);  //1表示私钥
    }

    /**
     * RSA公钥加密
     *
     * @param str       加密字符串
     * @param publicKey 公钥
     * @return 密文
     * @throws Exception 加密过程中的异常信息
     */
    public static String encrypt(String str, String publicKey) throws Exception {
        //base64编码的公钥
        byte[] decoded = Base64.decodeBase64(publicKey);
        RSAPublicKey pubKey = (RSAPublicKey) KeyFactory.getInstance("RSA").generatePublic(new X509EncodedKeySpec(decoded));
        //RSA加密
        Cipher cipher = Cipher.getInstance("RSA");
        cipher.init(Cipher.ENCRYPT_MODE, pubKey);
        String outStr = Base64.encodeBase64String(cipher.doFinal(str.getBytes("UTF-8")));
        return outStr;
    }

    /**
     * RSA私钥解密
     *
     * @param str        加密字符串
     * @param privateKey 私钥
     * @return 铭文
     * @throws Exception 解密过程中的异常信息
     */
    public static String decrypt(String str, String privateKey) throws Exception {
        //64位解码加密后的字符串
        byte[] inputByte = Base64.decodeBase64(str.getBytes("UTF-8"));
        //base64编码的私钥
        byte[] decoded = Base64.decodeBase64(privateKey);
        RSAPrivateKey priKey = (RSAPrivateKey) KeyFactory.getInstance("RSA").generatePrivate(new PKCS8EncodedKeySpec(decoded));
        //RSA解密
        Cipher cipher = Cipher.getInstance("RSA");
        cipher.init(Cipher.DECRYPT_MODE, priKey);
        String outStr = new String(cipher.doFinal(inputByte));
        return outStr;
    }

    /**
     * 私钥解密
     *
     * @param encryptedStr 已加密数据
     * @param privateKey   私钥(BASE64编码)
     * @return
     * @throws Exception
     */
    public static String decryptByPrivateKeyForLongStr(String encryptedStr, String privateKey) throws Exception {
        byte[] encryptedData = ByteFormat.hexToBytes(encryptedStr);
        byte[] keyBytes = com.pica.cloud.account.account.server.util.Base64.decode(privateKey);
        PKCS8EncodedKeySpec pkcs8KeySpec = new PKCS8EncodedKeySpec(keyBytes);
        KeyFactory keyFactory = KeyFactory.getInstance(KEY_ALGORITHM);
        Key privateK = keyFactory.generatePrivate(pkcs8KeySpec);
        Cipher cipher = Cipher.getInstance(keyFactory.getAlgorithm());
        cipher.init(Cipher.DECRYPT_MODE, privateK);
        int inputLen = encryptedData.length;
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        int offSet = 0;
        byte[] cache;
        int i = 0;
        // 对数据分段解密
        while (inputLen - offSet > 0) {
            if (inputLen - offSet > MAX_DECRYPT_BLOCK) {
                cache = cipher.doFinal(encryptedData, offSet, MAX_DECRYPT_BLOCK);
            } else {
                cache = cipher.doFinal(encryptedData, offSet, inputLen - offSet);
            }
            out.write(cache, 0, cache.length);
            i++;
            offSet = i * MAX_DECRYPT_BLOCK;
        }
        byte[] decryptedData = out.toByteArray();
        out.close();
        return new String(decryptedData);
    }

    // 获取验证码-加密
    public static EncryptEntity getAuthCodeEncrypt(AesAuthCodeReq req){
        BaseRequest authCode = new BaseRequest();
        authCode.setFlag(req.getFlag() == null ? 0 : req.getFlag());
        authCode.setMobile(req.getMobile());
        authCode.setDevice_token(req.getDevice_token());
        authCode.setBizType(req.getBizType());
        String authCodeStr = JSONObject.toJSONString(authCode);
//        System.out.println(authCodeStr);
        String contentResult = null;
        try {
            contentResult = AESUtil.aesEncrypt(authCodeStr, "YCPQPx4qpQjEjDea");
        } catch (Exception e) {
            e.printStackTrace();
        }
        String keyResult = null;
        try {
            keyResult = RSAUtil.encrypt("YCPQPx4qpQjEjDea",rsapublickey);
        } catch (Exception e) {
            e.printStackTrace();
        }
        EncryptEntity encryptTest = new EncryptEntity();
        encryptTest.setContent(contentResult);
        encryptTest.setKey(keyResult);

        return encryptTest;
//        System.out.println(JSONObject.toJSONString(encryptTest2));
    }

    // oneclick-加密
    public static EncryptEntity getOneClickEncrypt(AesAuthCodeReq req){
        OneClickLoginReq oneReq = new OneClickLoginReq();
        oneReq.setToken(req.getToken());
        String authCodeStr = JSONObject.toJSONString(oneReq);
//        System.out.println(authCodeStr);
        String contentResult = null;
        try {
            contentResult = AESUtil.aesEncrypt(authCodeStr, "YCPQPx4qpQjEjDea");
        } catch (Exception e) {
            e.printStackTrace();
        }
        String keyResult = null;
        try {
            keyResult = RSAUtil.encrypt("YCPQPx4qpQjEjDea",rsapublickey);
        } catch (Exception e) {
            e.printStackTrace();
        }
        EncryptEntity encryptTest = new EncryptEntity();
        encryptTest.setContent(contentResult);
        encryptTest.setKey(keyResult);

        return encryptTest;
    }

    public static void main(String[] args) throws Exception {
        //生成公钥和私钥
//        genKeyPair();
//        keyMap.put(0, publicKey);
//        keyMap.put(1, privateKey);
//        //加密字符串
//        String message = "df723820";
//        System.out.println("随机生成的公钥为:" + keyMap.get(0));
//        System.out.println("随机生成的私钥为:" + keyMap.get(1));
//        String messageEn = encrypt(message, keyMap.get(0));
//        System.out.println(message + "\t加密后的字符串为:" + messageEn);
//        String messageDe = decrypt(messageEn, keyMap.get(1));
//        System.out.println("还原后的字符串为:" + messageDe);

        genKeyPair();
        String publicKey = keyMap.get(0);
        System.out.println(publicKey);
        String privateKey = keyMap.get(1);
        System.out.println(privateKey);

        String messageEn = encrypt("{\"bizType\":1,\"device_token\":\"120c83f760bd0420c78\",\"mobile\":\"17868481983\",\"flag\":0}", publicKey);
        System.out.println(messageEn);

        String encryptMsg = "{\"key\":\"n2MyzrptkOsYE5c0lDn+5HU8x22DJTT49uad0+zeTt4Nj6RDrv3mJzKcc8LweYF5D7i4o812h9Gwn4drGJP+9Y8UOLNNRMx4+Au/V3TqOQFjve4jfUV8aewJK9Mildvsdk71ITe4YWd+8pQjuaQ4EkgAziFWEEuKiNnTEZjO8mE=\",\"content\":\"IRwE4SYrDk5RVpyycJy86n8Bu85FuQWt0Xb6wW+ITKObah0pkxKym+xwRwHMwMm5+UPmqNYhLsu5Dt39N14ZduwNDbktRaoAzvU6BHkdX4bWbkrPB7tw71J9k9zy7O/zaAzgo3SLUlj/xWB3KuOKcg==\"}";
        System.out.println(decrypt(encryptMsg,privateKey));

        String key2 = "";


    }
}
