package com.pica.cloud.account.account.server.service;

import com.pica.cloud.account.account.server.entity.LoginResult;
import com.pica.cloud.account.account.server.entity.PICAPDoctor;
import com.pica.cloud.account.account.server.req.BaseRequest;

public interface LoginService {
    /**
     * 密码登录功能
     *
     * @param request 参数模型
     * @return
     */
    LoginResult login(BaseRequest request);

    /**
     * 一键登录功能
     *
     * @param request 参数模型
     * @return
     */
    LoginResult loginAndRegister(BaseRequest request);

    /**
     * 微信登录
     *
     * @param baseRequest 参数模型
     */
    LoginResult loginByWeChat(BaseRequest baseRequest);

    /**
     * 微信登陆第二步
     *
     * @param request 参数模型
     * @return
     */
    LoginResult loginByWeChatStep(BaseRequest request);

    /**
     * 解除绑定
     *
     * @param acctId 账户id
     */
    void unbindWeChat(Integer acctId);


    /**
     * 绑定微信接口
     *
     * @param request 参数模型
     */
    void bindWeChat(BaseRequest request);

    PICAPDoctor queryDoctor(long doctorId);
}
