package com.pica.cloud.account.account.server.controller;

import com.aliyun.oss.common.utils.DateUtil;
import com.pica.cloud.account.account.server.entity.AccountUser;
import com.pica.cloud.account.account.server.entity.AccountPatientInfoEntity;
import com.pica.cloud.account.account.server.entity.EncryptEntity;
import com.pica.cloud.account.account.server.req.PatientReq;
import com.pica.cloud.account.account.server.service.PatientInfoService;
import com.pica.cloud.account.account.server.util.CryptoUtil;
import com.pica.cloud.foundation.entity.PicaResponse;
import com.pica.cloud.foundation.utils.utils.StringUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.apache.commons.beanutils.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import java.util.Date;

@Api(description = "云鹊健康用户信息信息资源")
@RestController
public class PatientInfoController extends AccountBaseController {

    @Autowired
    private PatientInfoService patientInfoService;



    /**
     * 获取用户信息接口
     *
     * @return
     */
    @ApiOperation("获取用户信息接口")
    @GetMapping(value = "/user/info")
    public PicaResponse getUserInfo() {
        AccountUser accountUser = super.getAccountUser();
        Integer userId = accountUser.getId();
        AccountPatientInfoEntity userInfo = patientInfoService.getUserInfo(userId);
        return PicaResponse.toResponse(userInfo);
    }

    /**
     * 修改用户信息接口
     *
     * @return
     */
    @ApiOperation("修改用户信息")
    @PutMapping(value = "/user/info")
    public PicaResponse putUserInfo(@RequestBody EncryptEntity entity) throws Exception {
        Integer id = super.getAccountUser().getId();
        PatientReq request = CryptoUtil.decrypt(entity, PatientReq.class);
        request.setId(id);
        request.setAcctId(super.getAcctId());
        AccountPatientInfoEntity accountPatientInfoEntity = new AccountPatientInfoEntity();
        BeanUtils.copyProperties(accountPatientInfoEntity, request);
        patientInfoService.updateUserInfo(accountPatientInfoEntity);
        return PicaResponse.toResponse();
    }

}
