package com.pica.cloud.account.account.server.service.impl;

import com.pica.cloud.account.account.server.entity.AccountInfoEntity;
import com.pica.cloud.account.account.server.entity.AccountPatientInfoEntity;
import com.pica.cloud.account.account.server.entity.LogUserInfoEntity;
import com.pica.cloud.account.account.server.enums.AccountTypeEnum;
import com.pica.cloud.account.account.server.log.AccountLogUtils;
import com.pica.cloud.account.account.server.mapper.AccountInfoDetailMapper;
import com.pica.cloud.account.account.server.mapper.AccountPatientInfoMapper;
import com.pica.cloud.account.account.server.service.PatientInfoService;
import com.pica.cloud.foundation.utils.utils.EncryptCreateUtil;
import org.apache.commons.beanutils.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.lang.reflect.InvocationTargetException;
import java.util.Date;

@Service
public class PatientInfoServerImpl implements PatientInfoService {

    @Autowired
    private AccountPatientInfoMapper accountPatientInfoMapper;

    @Autowired
    private AccountLogUtils accountLogUtils;

    @Autowired
    private AccountInfoDetailMapper accountInfoDetailMapper;

    @Override
    public void updateUserInfo(AccountPatientInfoEntity accountPatientInfoEntity) {
        accountPatientInfoEntity.setModifyTime(new Date());
        accountPatientInfoEntity.setModifyId(accountPatientInfoEntity.getAcctId());
        accountPatientInfoMapper.updateByPrimaryKeySelective(accountPatientInfoEntity);

        //用户信息更新日志
        Integer userId = accountPatientInfoEntity.getId();
        AccountPatientInfoEntity userInfo = getUserInfo(userId);
        LogUserInfoEntity logUserInfoEntity = new LogUserInfoEntity();
        try {
            BeanUtils.copyProperties(logUserInfoEntity, userInfo);
            Date currentTime = new Date();
            logUserInfoEntity.setCreateTime(currentTime);
            logUserInfoEntity.setModifyTime(currentTime);
            logUserInfoEntity.setLogType(AccountTypeEnum.LOG_TYPE_USER_INFO.getCode());
            accountLogUtils.info(logUserInfoEntity);

        } catch (IllegalAccessException e) {
            e.printStackTrace();
        } catch (InvocationTargetException e) {
            e.printStackTrace();
        }
    }

    @Override
    public AccountPatientInfoEntity getUserInfo(Integer userId) {
        return accountPatientInfoMapper.selectByUserId(userId);
    }

    @Override
    public AccountPatientInfoEntity getUserInfoByAcctId(Integer acctId) {
        return accountPatientInfoMapper.selectByAcctId(acctId);
    }

    @Override
    @Transactional
    public void addPatientInfo(AccountPatientInfoEntity entity, Integer userId) {
        String mobilePhone = entity.getMobilePhone();
        Date currentTime = new Date();
        AccountInfoEntity accountInfoEntity = new AccountInfoEntity();
        accountInfoEntity.setMobilePhone(mobilePhone);
        accountInfoEntity.setCreatedTime(currentTime);
        accountInfoEntity.setModifiedTime(currentTime);
        accountInfoEntity.setModifiedId(userId);
        accountInfoEntity.setCreatedId(userId);
        accountInfoEntity.setDeleteFlag(1);
        //居民：姓名和手机号
        accountInfoEntity.setName(entity.getName());
        accountInfoDetailMapper.insertSelective(accountInfoEntity);
        entity.setAcctId(accountInfoEntity.getId());
        entity.setMobilePhone(EncryptCreateUtil.encrypt(entity.getMobilePhone()));
        entity.setModifyId(userId);
        entity.setModifyTime(currentTime);
        accountPatientInfoMapper.insertSelective(entity);
    }
}
