package com.pica.cloud.account.account.server.constants;

/**
 * @author andong
 * @create 2018/12/11
 */
public class Constants {

    private Constants() {
    }

    public static final String SEND_MESSAGE = "/sms/send";

    /**
     * 批量短信url
     */
    public static final String BATCH_SEND_MESSAGE = "/sms/send_batch_dif";

    //token
    public static final String TOKEN = "token";
    //用户id
    public static final String USER_ID = "userId";
    //是否绑定
    public static final String BIND_FLAG = "bindFlag";
    //联合登录id
    public static final String UNION_ID = "unionId";
    //用户是否完善过信息
    public static final String USER_ENTIRE_FLAG = "entireFlag";

    /**
     * 请求头信息
     */
    public static final String HEADER_MOBILE = "mobile";
    public static final String HEADER_USER_TYPE = "游客";
    public static final String HEADER_BROWSER = "browser";
    public static final String HEADER_OPERATOR_SYSTEM = "os";
    public static final String HEADER_TERMINAL_TYPE = "terminalType";
    public static final String HEADER_SYS_CODE = "sysCode";
    public static final String HEADER_SYS_SOURCE = "app";
    public static final String HEADER_GUEST_ID = "guest_id";
    public static final String HEADER_IP = "ip";

    /**
     * 时间格式化
     */
    public static final String TIME_FORMAT = "yyyy-MM-dd HH:mm:ss";

    /** 密码登录错误次数缓存key */
    public static final String PWD_ERROR_NUM_KEY = "pwd-error-{mobile}";
    /** 账号锁定缓存key */
    public static final String ACCOUNT_LOCK_KEY = "account-lock-{mobile}";
    /** 密码登录错误次数缓存时长*/
    public static final int PWD_ERROR_NUM_SECONDS = 24 * 60 * 60;

    /** 苹果后台获取公钥路径 */
    public static final String APPLE_GET_PUBLIC_KEY_URL = "https://appleid.apple.com/auth/keys";
    /** 苹果组织官网地址 */
    public static final String APPLE_ISSUE_URL = "https://appleid.apple.com";

    /** h5端发送短信验证码接口开关缓存key */
    public static final String AUTHCODE_H5_SWITCH_KEY = "AUTH-CODE-H5-SWITCH";

    /** 验证码缓存key前缀 */
    public static final String AUTH_CODE_PREFIX = "authCode-";

    /** 注册逻辑幂等处理缓存key */
    public static final String REPEAT_REGISTER_PREFIX = "repeat-register—";

}
