package com.pica.cloud.account.account.server.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.pica.cloud.account.account.common.req.circle.CircleAcctInit;
import com.pica.cloud.account.account.common.req.circle.CircleAcctInitReq;
import com.pica.cloud.account.account.common.req.circle.DiyAcctInit;
import com.pica.cloud.account.account.common.req.shop.ShopAcctInit;
import com.pica.cloud.account.account.common.req.shop.ShopAcctInitReq;
import com.pica.cloud.account.account.common.req.circle.DiyAcctInitReq;
import com.pica.cloud.account.account.server.entity.Account;
import com.pica.cloud.account.account.server.enums.AccountTypeEnum;
import com.pica.cloud.account.account.server.mapper.AccountMapper;
import com.pica.cloud.account.account.server.service.AccountService;
import com.pica.cloud.account.account.server.service.CircleAccountService;
import com.pica.cloud.foundation.encryption.common.constants.EncryptConstants;
import com.pica.cloud.foundation.encryption.util.EncryptUtils;
import com.pica.cloud.foundation.entity.PicaException;
import com.pica.cloud.foundation.entity.PicaResultCode;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.*;


/**
 * @DESCRIPTOIN:
 * @AUTHOR: joy
 * @DATE:2020/6/21 10:25 上午
 */
@Service
public class CircleAccountServiceImpl implements CircleAccountService {

    private static Logger logger = LoggerFactory.getLogger(CircleAccountServiceImpl.class);

    @Autowired
    private AccountService accountService;

    @Autowired
    private AccountMapper accountMapper;

    @Override
    @Transactional
    public List<Integer> createCircleAccount(CircleAcctInitReq circleAcctInitReq) {
        logger.info("createCircleAccount:{}", JSONObject.toJSONString(circleAcctInitReq));
        List<CircleAcctInit> circleAcctInits = circleAcctInitReq.getCircleAcctInitList();
        List<Integer> savedIds = new ArrayList<>();
        try {
            for (CircleAcctInit acct : circleAcctInits) {
                Account dbAcct = accountMapper.getByMobilePhone(acct.getEncryMobile());  //获取医生表账号信息
                if (null == dbAcct) {
                    Account account = new Account();
                    account.setName(acct.getUserName());
                    account.setNickname(acct.getUserName());
                    account.setMobilePhone(acct.getEncryMobile());
                    account.setRegisterSource(circleAcctInitReq.getRegisterSource());
                    accountService.createAccount(account, AccountTypeEnum.PRODUCT_TYPE_ECO_LIVE.getCode());
                    savedIds.add(account.getId().intValue());
                    logger.info("createCircleAccount insert {}", account.getId().intValue());
                } else {
                    savedIds.add(dbAcct.getId().intValue());
                    logger.info("createCircleAccount exist {}", dbAcct.getId().intValue());
                }
            }
        } catch (Exception e) {
            logger.error("createCircleAccount error:{}", e.getMessage());
            throw e;
        }

        return savedIds;
    }

    @Override
    public List<Integer> createDiyAccount(DiyAcctInitReq diyAcctInitReq) {
        logger.info("createDiyAccount:{}", JSONObject.toJSONString(diyAcctInitReq));
        List<Integer> savedIds = new ArrayList<>();
        try {
            if (CollectionUtils.isNotEmpty(diyAcctInitReq.getDecryMobileList())) {
                for (String decryMobile : diyAcctInitReq.getDecryMobileList()) {
                    String encryMobile = EncryptUtils.encryptContent(decryMobile, EncryptConstants.ENCRYPT_TYPE_MOBILE);
                    Account dbAcct = accountMapper.getByMobilePhone(encryMobile);  //获取医生表账号信息
                    if (null == dbAcct) {
                        Account account = new Account();
                        account.setMobilePhone(encryMobile);
                        account.setRegisterSource(5); //admin
                        accountService.createAccount(account, AccountTypeEnum.PRODUCT_TYPE_ECO_LIVE.getCode());
                        savedIds.add(account.getId().intValue());
                        logger.info("createDiyAccount insert {}", account.getId().intValue());
                    } else {
                        savedIds.add(dbAcct.getId().intValue());
                        logger.info("createDiyAccount exist {}", dbAcct.getId().intValue());
                    }
                }
            } else {
                if (CollectionUtils.isNotEmpty(diyAcctInitReq.getDiyAcctInitList())) {
                    for (DiyAcctInit acctInit : diyAcctInitReq.getDiyAcctInitList()) {
                        String encryMobile = EncryptUtils.encryptContent(acctInit.getDecryMobile(), EncryptConstants.ENCRYPT_TYPE_MOBILE);
                        Account dbAcct = accountMapper.getByMobilePhone(encryMobile);  //获取医生表账号信息
                        if (null == dbAcct) {
                            Account account = new Account();
                            account.setName(acctInit.getUserName());
                            account.setMobilePhone(encryMobile);
                            account.setRegisterSource(5); //admin
                            accountService.createAccount(account, AccountTypeEnum.PRODUCT_TYPE_ECO_LIVE.getCode());
                            savedIds.add(account.getId().intValue());
                            logger.info("createDiyAccount insert {}", account.getId().intValue());
                        } else {
                            savedIds.add(dbAcct.getId().intValue());
                            logger.info("createDiyAccount exist {}", dbAcct.getId().intValue());
                        }
                    }
                }
            }
        } catch (Exception e) {
            logger.error("createDiyAccount error:{}", e.getMessage());
            throw e;
        }

        return savedIds;
    }

    @Override
    public Map<String, Integer> createShopAccount(ShopAcctInitReq shopAcctInitReq) {
        Map<String, Integer> rtnMap = new HashMap();

        logger.info("createShopAccount:{}", JSONObject.toJSONString(shopAcctInitReq));
        List<ShopAcctInit> shopAcctInits = shopAcctInitReq.getShopAcctInitList();
//        List<Integer> savedIds = new ArrayList<>();
        try {
            for (ShopAcctInit acct : shopAcctInits) {
                String encryMobile = EncryptUtils.encryptContent(acct.getMobile(), EncryptConstants.ENCRYPT_TYPE_MOBILE);
                Account dbAcct = accountMapper.getByMobilePhone(encryMobile);  //获取医生表账号信息
                if (null == dbAcct) {
                    Account account = new Account();
                    account.setName(acct.getUserName());
                    account.setNickname(acct.getUserName());
                    account.setMobilePhone(encryMobile);
                    account.setRegisterSource(shopAcctInitReq.getRegisterSource());
                    accountService.createAccount(account, AccountTypeEnum.PRODUCT_TYPE_DOCTOR.getCode());
//                    savedIds.add(account.getId().intValue());
                    logger.info("createShopAccount insert {}", account.getId().intValue());
                    rtnMap.put(acct.getMobile(), account.getId().intValue());
                } else {
//                    savedIds.add(dbAcct.getId().intValue());
                    logger.info("createShopAccount exist {}", dbAcct.getId().intValue());
                    rtnMap.put(acct.getMobile(), dbAcct.getId().intValue());
                }
            }
        } catch (Exception e) {
            logger.error("createShopAccount error:{}", e.getMessage());
            throw e;
        }

        return rtnMap;
    }


    @Transactional
    @Override
    public List<Integer> registerAndCertify(DiyAcctInitReq diyAcctInitReq) {
        logger.info("createDiyAccount:{}", JSONObject.toJSONString(diyAcctInitReq));
        List<Integer> savedIds = new ArrayList<>();
        Map<Integer,DiyAcctInit> idCardMap = new HashMap<>();
        try {
            if (CollectionUtils.isNotEmpty(diyAcctInitReq.getDiyAcctInitList())) {
                for (DiyAcctInit acctInit : diyAcctInitReq.getDiyAcctInitList()) {
                    String encryMobile = EncryptUtils.encryptContent(acctInit.getDecryMobile(), EncryptConstants.ENCRYPT_TYPE_MOBILE);
                    Account dbAcct = accountMapper.getByMobilePhone(encryMobile);  //获取医生表账号信息
                    if (null == dbAcct) {
                        // 未注册时 注册用户
                        Account account = new Account();
                        account.setName(acctInit.getUserName()); // 真实姓名
                        account.setMobilePhone(encryMobile);
                        account.setRegisterSource(5); //admin
                        accountService.createAccount(account, AccountTypeEnum.PRODUCT_TYPE_DOCTOR.getCode());
                        savedIds.add(account.getId().intValue());
                        idCardMap.put(account.getId().intValue(), acctInit); // 使用入参的card
                        logger.info("createDiyAccount insert {}", account.getId().intValue());
                    } else {
                        savedIds.add(dbAcct.getId().intValue());
                        idCardMap.put(dbAcct.getId().intValue(), acctInit); // 使用入参的card
                        logger.info("createDiyAccount exist {}", dbAcct.getId().intValue());
                    }
                }
            }
        } catch (Exception e) {
            logger.error("registerAndCertify error:{}", e.getMessage());
            throw e;
        }

        // 对这批医生进行实名认证状态更新；
        for(Integer id : savedIds){
            try {
                // check 身份证号是否已被他人使用
                String encryCard = EncryptUtils.encryptContent(idCardMap.get(id).getCard(), EncryptConstants.ENCRYPT_TYPE_DOCTOR_IDNO);
                logger.info(encryCard);
                Account accountCard = accountMapper.getByCard(encryCard);
                String encryMobile = EncryptUtils.encryptContent(idCardMap.get(id).getDecryMobile(), EncryptConstants.ENCRYPT_TYPE_MOBILE);

                if(accountCard != null && !accountCard.getMobilePhone().equals(encryMobile)){
                    throw new PicaException(PicaResultCode.PARAM_IS_INVALID.code(), "身份证号已被使用：" + encryCard);
                }

                Account doctor = accountMapper.selectById(id);

                boolean updateFlag = false;
                if(doctor.getStatus() != null && doctor.getStatus() != 3){
                    doctor.setStatus(3);
                    updateFlag = true;
                }
                if(doctor.getCertifyStatus() != null && doctor.getCertifyStatus() != 3){
                    doctor.setCertifyStatus(3);
                    updateFlag = true;
                }
                if(!updateFlag){
                    continue;
                }
                doctor.setName(idCardMap.get(id).getUserName());
                doctor.setNation("1");
                Map map = getBirthdayAgeSex(idCardMap.get(id).getCard());
                doctor.setSex(Integer.parseInt(map.get("sex").toString()));
                doctor.setBirthday(getDateByStr(map.get("birthday").toString()));

                doctor.setCard(encryCard);
                doctor.setModifyId(Long.valueOf(134));
                doctor.setNativePlace("接口导入");

                accountMapper.updateByIdSelective(doctor);
            } catch (NumberFormatException e) {
                logger.error("registerAndCertify update error:{}", e.getMessage());
            }
        }

        return savedIds;
    }

    public static void main(String[] args) {
        Map map =getBirthdayAgeSex("310115198210277251");
        System.out.println(map);
    }

    public static Date getDateByStr(String dateStr) {
        try {
            DateFormat format = new SimpleDateFormat("yyyy-MM-dd");
            return format.parse(dateStr);
        } catch (Exception e) {
            logger.error("getDateByStr error:{}", e);
            return new Date();
        }
    }

    public static Map<String, String> getBirthdayAgeSex(String idCardNo) {
        String birthday = "";
        String age = "";
        String sexCode = "";

        int year = Calendar.getInstance().get(Calendar.YEAR);
        char[] number = idCardNo.toCharArray();
        boolean flag = true;
        if (number.length == 15) {
            for (int x = 0; x < number.length; x++) {
                if (!flag){
                    return new HashMap<String, String>();
                }
                flag = Character.isDigit(number[x]);
            }
        } else if (number.length == 18) {
            for (int x = 0; x < number.length - 1; x++) {
                if (!flag){
                    return new HashMap<String, String>();
                }
                flag = Character.isDigit(number[x]);
            }
        }
        if (flag && idCardNo.length() == 15) {
            birthday = "19" + idCardNo.substring(6, 8) + "-"
                    + idCardNo.substring(8, 10) + "-"
                    + idCardNo.substring(10, 12);
            sexCode = Integer.parseInt(idCardNo.substring(idCardNo.length() - 3, idCardNo.length())) % 2 == 0 ? "0" : "1";
            age = (year - Integer.parseInt("19" + idCardNo.substring(6, 8))) + "";
        } else if (flag && idCardNo.length() == 18) {
            birthday = idCardNo.substring(6, 10) + "-"
                    + idCardNo.substring(10, 12) + "-"
                    + idCardNo.substring(12, 14);
            sexCode = Integer.parseInt(idCardNo.substring(idCardNo.length() - 4, idCardNo.length() - 1)) % 2 == 0 ? "0" : "1";
            age = (year - Integer.parseInt(idCardNo.substring(6, 10))) + "";
        }
        Map<String, String> map = new HashMap<String, String>();
        map.put("birthday", birthday);
        map.put("age", age);
        map.put("sex", sexCode);
        return map;
    }

}
