package com.pica.cloud.account.account.server.service.impl;

import com.pica.cloud.account.account.server.entity.AccountInfoEntity;
import com.pica.cloud.account.account.server.entity.Doctor;
import com.pica.cloud.account.account.server.enums.AccountExceptionEnum;
import com.pica.cloud.account.account.server.exception.AccountException;
import com.pica.cloud.account.account.server.mapper.AccountInfoDetailMapper;
import com.pica.cloud.account.account.server.mapper.DoctorMapper;
import com.pica.cloud.account.account.server.service.ModifyMobileService;
import com.pica.cloud.account.account.server.util.AESUtil;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.Date;

@Service
public class ModifyMobileServiceImpl implements ModifyMobileService {

    @Autowired
    private AccountInfoDetailMapper accountInfoDetailMapper;

    @Autowired
    private DoctorMapper doctorMapper;

    @Value("${doubleWritingMode}")
    private boolean doubleWritingMode;

    @Override
    @Transactional
    public void modify(Integer acctId, String mobile) {
        AccountInfoEntity entity = accountInfoDetailMapper.selectByPrimaryKey(acctId);
        String mobilePhone = entity.getMobilePhone();
        if (StringUtils.isNotEmpty(mobilePhone) && AESUtil.decryptV0(mobilePhone).equals(mobile)) {
            throw new AccountException(AccountExceptionEnum.PICA_MOBILE_SAME);
        }
        AccountInfoEntity accountInfoEntity = new AccountInfoEntity();
        accountInfoEntity.setId(acctId);
        accountInfoEntity.setModifiedId(acctId);
        accountInfoEntity.setModifiedTime(new Date());
        accountInfoEntity.setMobilePhone(AESUtil.encryptV0(mobile));
        accountInfoDetailMapper.updateMobileByPrimaryKey(accountInfoEntity);
        if (doubleWritingMode) {
            //更新p_doctor表中用户的手机号
            Date currentTime = new Date();
            Doctor doctor = new Doctor();
            doctor.setAcctId(acctId);
            doctor.setModifyTime(currentTime);
            doctor.setModifyId(acctId);
            doctor.setMobilePhone(AESUtil.encryptV0(mobile));
            doctorMapper.updateByAcctId(doctor);
        }
    }
}
