package com.pica.cloud.account.account.server.mapper;

import com.pica.cloud.account.account.server.entity.Account;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import java.util.List;
import java.util.Map;

/**
 * 账号Mapper
 * @author andong
 * @create 2019/5/20
 */
@Mapper
public interface AccountMapper {

    //根据id获取账号
    Account selectById(long id);

    //新增账号
    void insertSelective(Account account);

    //更新账号
    int updateByIdSelective(Account account);

    //根据手机号获取账号
    Account getByMobilePhone(@Param("mobilePhone") String mobilePhone);

    //根据微信unionid获取账号
    Account getByUnionid(@Param("unionid") String unionid);

    List<Map<String, Object>> getHospitalInfoByPage(@Param("id") Long id, @Param("offset") int offset, @Param("size") int size);
}
