package com.pica.cloud.account.account.server.util;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import javax.servlet.http.HttpServletRequest;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Enumeration;

public class IPUtil {
    private static Logger logger = LoggerFactory.getLogger(IPUtil.class);

    /**
     * @Description 获取请求的外网ip
     * @Author Chongwen.jiang
     * @Date 2020/2/25 9:34
     * @ModifyDate 2020/2/25 9:34
     * @Params [request]
     * @Return java.lang.String
     */
    public static String getIpAdrress(HttpServletRequest request) {
        String ip = null;

        //X-Forwarded-For：Squid 服务代理
        String ipAddresses = request.getHeader("X-Forwarded-For");
        Enumeration<String> headerNames = request.getHeaderNames();
        StringBuffer sb = new StringBuffer("getIpAdrress-");
        while (headerNames.hasMoreElements()) {
            //打印所有头信息
            String s = headerNames.nextElement();
            String header = request.getHeader(s);
//            System.out.println(s+"::::"+header);
            sb.append("headerName:").append(s)
            .append(" headerVal:").append(header).append(", ");
        }
        logger.info("getIpAdrress-headers:{}", sb.toString());

//        System.out.println("headerNames:"+ JSON.toJSONString(headerNames));
//        System.out.println("RemoteHost:"+request.getRemoteHost());
//        System.out.println("RemoteAddr:"+request.getRemoteAddr());

        String unknown = "unknown";
        if (ipAddresses == null || ipAddresses.length() == 0 || unknown.equalsIgnoreCase(ipAddresses)) {
            //Proxy-Client-IP：apache 服务代理
            ipAddresses = request.getHeader("Proxy-Client-IP");
        }

        if (ipAddresses == null || ipAddresses.length() == 0 || unknown.equalsIgnoreCase(ipAddresses)) {
            //WL-Proxy-Client-IP：weblogic 服务代理
            ipAddresses = request.getHeader("WL-Proxy-Client-IP");
        }

        if (ipAddresses == null || ipAddresses.length() == 0 || unknown.equalsIgnoreCase(ipAddresses)) {
            //HTTP_CLIENT_IP：有些代理服务器
            ipAddresses = request.getHeader("HTTP_CLIENT_IP");
        }

        if (ipAddresses == null || ipAddresses.length() == 0 || unknown.equalsIgnoreCase(ipAddresses)) {
            //X-Real-IP：nginx服务代理
            ipAddresses = request.getHeader("X-Real-IP");
        }

        //有些网络通过多层代理，那么获取到的ip就会有多个，一般都是通过逗号（,）分割开来，并且第一个ip为客户端的真实IP
        if (ipAddresses != null && ipAddresses.length() != 0) {
            ip = ipAddresses.split(",")[0];
        }

        //还是不能获取到，最后再通过request.getRemoteAddr();获取
        if (ip == null || ip.length() == 0 || unknown.equalsIgnoreCase(ipAddresses)) {
            ip = request.getRemoteAddr();
        }

        if("0:0:0:0:0:0:0:1".equalsIgnoreCase(ip)){
            ip = "127.0.0.1";
        }

        getPublicIp();
        return ip;
    }

    /**
     * @Description 获取公网ip
     * @Author Chongwen.jiang
     * @Date 2020/2/24 16:54
     * @ModifyDate 2020/2/24 16:54
     * @Params []
     * @Return java.lang.String
     */
    private static String getPublicIp() {
        try {
            logger.info("getPublicIp...start......");
            String path = "https://2020.ip138.com/";
            URL url = new URL(path);
            HttpURLConnection conn = (HttpURLConnection) url.openConnection();
            conn.setRequestProperty("contentType", "GBK");
            conn.setConnectTimeout(5 * 1000);
            conn.setRequestMethod("GET");
            InputStream inStream = conn.getInputStream();
            logger.info("getPublicIp.step2");
            BufferedReader in = new BufferedReader(new InputStreamReader(
                    inStream, "GBK"));
            StringBuffer buffer = new StringBuffer();
            String line = "";
            // 读取获取到内容的最后一行,写入
            while ((line = in.readLine()) != null) {
                buffer.append(line);
            }
            logger.info("getPublicIp.step3");
            String str = buffer.toString();
            logger.info("getPublicIp.step4.str:{}", str);
            String ipString1 = str.substring(str.indexOf("["));
            // 您的iP地址是：[223.112.202.205] 来自：江苏省常州市 移动
            String ipsString2 = ipString1.substring(ipString1.indexOf("[") + 1,
                    ipString1.lastIndexOf("]"));
            //获取当前IP地址所在地址
            /*String ipsString3=ipString1.substring(ipString1.indexOf(": "),ipString1.lastIndexOf("</center>"));
            System.err.println(ipsString3);*/
            return ipsString2;
        } catch (Exception e) {
            logger.error("get-public-ip-timout-getPublicIp");
            return "连接超时";
        }
    }

}
