package com.pica.cloud.account.account.server.util;

import com.pica.cloud.foundation.completeness.client.utils.IntactUtils;
import com.pica.cloud.foundation.completeness.contract.req.LogParamsReq;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

/**
 * @param <T>
 * @author jiao.yu
 * @version V1.0
 * @Description:
 * @date 2020/5/22 16:04
 */
@Service
public class IntactUtil {
    private final static Logger logger = LoggerFactory.getLogger(IntactUtil.class);

    /**
     * 对接新旭事务一致性
     * @param batchNo
     * @param methodName
     * @param status
     * @param params
     */
    public void sendIntact(String batchNo,String methodName,Integer status,String params){
        logger.info("开始事务一致性，参数为：batchNo:"+batchNo+",methodName:"+methodName+",status:"+status+",params:"+params);
        LogParamsReq req = new LogParamsReq();
        req.setBatchNo(batchNo);
        req.setMethodName(methodName);
        req.setStatus(status);
        req.setParams(params);
        IntactUtils.sendIntact(req);
        logger.info("结束事务一致性");

    }
}
