package com.pica.cloud.account.account.server.util.captcha;

import com.google.common.collect.Range;
import com.google.common.collect.RangeMap;
import com.google.common.collect.TreeRangeMap;
import java.awt.*;
import java.io.IOException;

/**
 * @author Laurence Cao
 *
 */
public abstract class CaptchaGenerator {

    protected RangeMap<Integer, CaptchaContext> ctxs = TreeRangeMap.create();

    public CaptchaGenerator(boolean showGrid) throws FontFormatException, IOException {
        int h = 40;
        ctxs.put(Range.closed(0, h), new CaptchaContext(h * 4, h, h / 5 * 4, showGrid));
        h *= 2;
        ctxs.put(Range.closed(h / 2, h), new CaptchaContext(h * 4, h, h / 5 * 4, showGrid));
        h *= 2;
        ctxs.put(Range.closed(h / 2, Integer.MAX_VALUE), new CaptchaContext(h * 4, h, h / 5 * 4, showGrid));
    }

    @SuppressWarnings("unused")
    public byte[] createCaptcha(String text, int width, int height) {
        CaptchaContext ctx = ctxs.get(height);
        if (ctx == null) {
            ctx = ctxs.get(0);
        }
        return CaptchaUtil.generateImage(text, ctx);
    }

    public abstract String generateChars(int size);
}
