// Copyright 2016-2101 Pica.
package com.pica.cloud.account.account.server.req;

import com.pica.cloud.account.account.server.enums.AccountExceptionEnum;
import com.pica.cloud.foundation.entity.PicaWarnException;
import com.pica.cloud.foundation.utils.utils.ValidateUtils;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.apache.commons.lang.StringUtils;

import java.util.List;
import java.util.Objects;
import java.util.regex.Pattern;


/**
 * @Author qinwh
 * @Date 2022/3/1 10:45
 */
@ApiModel
@Data
public class HospitalSaasUserReq {

    @ApiModelProperty("人员id")
    private Long id;

    @ApiModelProperty("姓名")
    private String name;

    @ApiModelProperty("机构id")
    private Integer hospitalId;

    @ApiModelProperty("机构id")
    private String hospitalName;

    @ApiModelProperty("手机号")
    private String mobile;

    @ApiModelProperty("密码")
    private String password;

    @ApiModelProperty("备注")
    private String comment;

    @ApiModelProperty("角色id  0 无角色 1 主管理员 2 管理员 3 saas系统管理员 4 saas用户")
    private List<Long> roleId;

    @ApiModelProperty("产品类型 1.云鹊医 2.云鹊健康 3.直播 4.crm(saas注册固定写死为crm)")
    private Integer productType;

    @ApiModelProperty("资源类型 1表示安卓，2表示ios，3表示web，4表示H5登录，5表示admin后台 6.SAAS")
    private Integer sourceType;


    @ApiModelProperty("登录来源  0:运营平台 1:saas")
    private Integer loginFlag = 0;

    public void checkInsertParams() {
        if (StringUtils.isBlank(this.mobile)) {
            throw new PicaWarnException(AccountExceptionEnum.PICA_NOT_EMPTY.getCode(), "手机号不能为空");
        }
        if (Objects.isNull(this.hospitalId)) {
            throw new PicaWarnException(AccountExceptionEnum.PICA_NOT_EMPTY.getCode(), "机构id不能为空");
        }
        if (StringUtils.isBlank(this.name)) {
            throw new PicaWarnException(AccountExceptionEnum.PICA_NOT_EMPTY.getCode(), "姓名不能为空");
        }
        if (StringUtils.isBlank(this.password)) {
            throw new PicaWarnException(AccountExceptionEnum.PICA_NOT_EMPTY.getCode(), "密码不能为空");
        }
        if (this.name.length() > 16) {
            throw new PicaWarnException(AccountExceptionEnum.PICA_NOT_EMPTY.getCode(), "姓名长度必须≤16字符！");
        }
        if (!ValidateUtils.isMobile(this.mobile)) {
            throw new PicaWarnException(AccountExceptionEnum.PICA_NOT_EMPTY.getCode(), "手机号格式不正确！");
        }
        if (null == this.productType) {
            throw new PicaWarnException(AccountExceptionEnum.PICA_NOT_EMPTY.getCode(), "产品类型不能为空！");
        }
        if (null == this.sourceType) {
            throw new PicaWarnException(AccountExceptionEnum.PICA_NOT_EMPTY.getCode(), "资源类型不能为空！");
        }
        if (!Pattern.matches("^[A-Za-z0-9]{6,10}$", this.password)) {
            throw new PicaWarnException(AccountExceptionEnum.PICA_NOT_EMPTY.getCode(), "密码需由6-10位字母或数字组成！");
        }
        if (Objects.nonNull(this.comment) && this.comment.length() > 100) {
            throw new PicaWarnException(AccountExceptionEnum.PICA_NOT_EMPTY.getCode(), "备注长度须≤100字符");
        }

    }
}
