package com.pica.cloud.account.account.server.service.impl;


import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.pica.cloud.account.account.server.entity.*;
import com.pica.cloud.account.account.server.enums.AccountTypeEnum;
import com.pica.cloud.account.account.server.log.AccountLogEntityUtils;
import com.pica.cloud.account.account.server.log.AccountLogUtils;
import com.pica.cloud.account.account.server.mapper.AccountInfoDetailMapper;
import com.pica.cloud.account.account.server.mapper.DoctorMapper;
import com.pica.cloud.account.account.server.model.OneClickProcessor;
import com.pica.cloud.account.account.server.req.BaseRequest;
import com.pica.cloud.account.account.server.req.OneClickLoginReq;
import com.pica.cloud.account.account.server.service.LoginV1Service;
import com.pica.cloud.account.account.server.service.RegisterService;
import com.pica.cloud.account.account.server.util.AESUtil;
import com.pica.cloud.account.account.server.util.AccountUtils;
import com.pica.cloud.account.account.server.util.IntactUtil;
import com.pica.cloud.account.account.server.util.TokenUtils;
import com.pica.cloud.foundation.completeness.client.utils.IntactUtils;
import com.pica.cloud.foundation.encryption.common.constants.EncryptConstants;
import com.pica.cloud.foundation.encryption.util.EncryptUtils;
import com.pica.cloud.foundation.entity.PicaException;
import com.pica.cloud.foundation.entity.PicaResultCode;
import com.pica.cloud.foundation.utils.utils.ValidateUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Date;

@Service
public class LoginV1ServiceImpl implements LoginV1Service {

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private RegisterService registerService;

    @Autowired
    private OneClickProcessor oneClickProcessor;

    @Autowired
    private AccountInfoDetailMapper accountInfoDetailMapper;

    @Autowired
    private IntactUtil intactUtil;

    @Autowired
    private AccountUtils accountUtils;

    @Autowired
    private TokenUtils tokenUtils;

    @Autowired
    private DoctorMapper doctorInfoMapper;

    @Autowired
    private AccountLogUtils picaLogUtils;


    /**
     * 新版一键登录
     * @param req
     * @return
     */
    @Override
    public LoginResult oneClickLogin(OneClickLoginReq req) {
        QueryMobileEntity queryMobileEntity = oneClickProcessor.tokenExchangeMobile(req.getToken(), req.getSourceType());
        if (queryMobileEntity == null || StringUtils.isBlank(queryMobileEntity.getMobile()) || !ValidateUtils.isMobile(queryMobileEntity.getMobile())) {
            logger.error("oneClickLogin 闪验获取出错-queryMobileEntity:{}", JSONObject.toJSONString(queryMobileEntity));
            throw new PicaException(PicaResultCode.INTERFACE_INVOKE_EXCEPTION.code(), "获取手机号失败！");
        }
        queryMobileEntity.setSourceType(req.getSourceType());
        AccountInfoEntity accountInfoEntity = accountInfoDetailMapper.selectByMobile(AESUtil.encryptV0(queryMobileEntity.getMobile()));
        BaseRequest baseRequest = new BaseRequest();
        baseRequest.setMobile(queryMobileEntity.getMobile());
        baseRequest.setSourceType(req.getSourceType());
        baseRequest.setProductType(req.getProductType());
        baseRequest.setLoginIp(req.getLoginIp());
        baseRequest.setUserTokenTourist(req.getUserTokenTourist());
        LoginResult result;
        if (accountInfoEntity == null) {
            //说明是注册功能
            result = registerService.register(baseRequest, queryMobileEntity);
        } else {
            //登录功能
            result = processLogin(baseRequest, accountInfoEntity.getId(), AccountTypeEnum.LOGIN_ONE_CLICK.getCode(), queryMobileEntity);

            if (req.getCheckFlag()) {
                // 直接登录，不需要校验手机号
            } else {
                // 第一次点"一键登录"接口，需要比对上次登录的手机号与这次是否一样
            }

        }
        return result;
    }

    private LoginResult processLogin(BaseRequest baseRequest, Integer acctId, Integer loginType, QueryMobileEntity queryMobileEntity) {
        //接入新旭事务一致性
        String batchNo = IntactUtils.getUUID();
        intactUtil.sendIntact(batchNo, "processLogin", com.pica.cloud.foundation.completeness.contract.constants.CommonConstants.INTACT_CONTENT_LOG_STATUS_1, "baseRequest:" + JSON.toJSONString(baseRequest) + ",+acctId:" + acctId + ",loginType:" + loginType + ",queryMobileEntity:" + JSON.toJSONString(queryMobileEntity));
        Date currentTime = new Date();
        Long userId = accountUtils.getUserIdByAcctId(baseRequest.getProductType(), acctId);
        Account account = new Account();
        account.setId(userId);
        account.setAcctId(acctId);
        account.setCreatTime(currentTime);
        account.setMobilePhone(baseRequest.getMobile());
        account.setRegisterSource(baseRequest.getSourceType());
        String newToken = tokenUtils.generateToken(account);
        LoginResult result = new LoginResult();
        result.setToken(newToken);
        result.setUserId(userId);
        result.setMobile(baseRequest.getMobile());
        result.setDoctorId(EncryptUtils.encryptContent(userId + "", EncryptConstants.ENCRYPT_TYPE_ID));
        //是否完善过个人信息（云鹊医app才需要）
        if (baseRequest.getProductType() != AccountTypeEnum.PRODUCT_TYPE_HEALTH.getCode()) {
            Doctor doctorEntity = doctorInfoMapper.selectByPrimaryKey(userId.intValue());
            result.setEntireFlag(doctorEntity.getEntireFlag());
        }
        //记录登录日志
        LogLoginEntity entity = AccountLogEntityUtils.getLogLoginEntity(acctId, baseRequest.getProductType(), baseRequest.getSourceType(),
                loginType, baseRequest.getLoginIp(), AccountTypeEnum.LOGIN_STATUS_SUCCESS.getCode(), AccountTypeEnum.LOG_TYPE_LOGIN.getCode(), newToken, 1, baseRequest.getUserTokenTourist());
        if (queryMobileEntity != null) {
            entity.setQueryMobileEntity(queryMobileEntity);
        }
        picaLogUtils.info(entity);
        intactUtil.sendIntact(batchNo, "processLogin", com.pica.cloud.foundation.completeness.contract.constants.CommonConstants.INTACT_CONTENT_LOG_STATUS_3, "baseRequest:" + JSON.toJSONString(baseRequest) + ",+acctId:" + acctId + ",loginType:" + loginType + ",queryMobileEntity:" + JSON.toJSONString(queryMobileEntity));

        return result;
    }


}
