// Copyright 2016-2101 Pica.
package com.pica.cloud.account.account.server.controller;

import com.pica.cloud.account.account.server.req.HospitalRoleDetailReq;
import com.pica.cloud.account.account.server.req.HospitalRoleListReq;
import com.pica.cloud.account.account.server.resp.HospitalRoleDto;
import com.pica.cloud.account.account.server.resp.HospitalRoleResp;
import com.pica.cloud.account.account.server.service.HospitalSaasRoleService;
import com.pica.cloud.foundation.entity.PicaResponse;
import com.pica.cloud.foundation.service.starter.interceptor.EnabledLoginValidate;
import com.pica.cloud.foundation.utils.entity.PicaUser;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

/**
 * @Author qinwh
 * @Date 2022/3/1 15:54
 */
@Api(description = "机构saas角色资源")
@RestController("/saas")
public class HospitalSaasRoleController extends AccountBaseController {
    @Autowired
    HospitalSaasRoleService hospitalSaasRoleService;

    @ApiOperation("机构saas角色-新增或更新")
    @PostMapping(value = "/hospital/role/insertAndModify")
    @EnabledLoginValidate
    public PicaResponse<Integer> insertAndModify(@RequestBody HospitalRoleDetailReq req) {
        PicaUser user = fetchPicaUser();
        return PicaResponse.toResponse(hospitalSaasRoleService.insertAndModify(req, user));
    }

    @ApiOperation("机构saas角色-删除")
    @DeleteMapping(value = "/hospital/role/delete{id}")
    @EnabledLoginValidate
    public PicaResponse<Integer> delete(@PathVariable("id") Long id) {
        return PicaResponse.toResponse(hospitalSaasRoleService.delete(id));
    }

    @ApiOperation("机构saas平台角色列表")
    @PostMapping(value = "/hospital/role/listByPage")
    @EnabledLoginValidate
    public PicaResponse<HospitalRoleResp> ListByPage(@RequestBody HospitalRoleListReq req) {
        HospitalRoleResp hospitalRoleResp = hospitalSaasRoleService.ListByPage(req);
        return PicaResponse.toResponse(hospitalRoleResp);
    }


    @ApiOperation("机构saas角色-角色")
    @GetMapping(value = "/hospital/role/getRoleDetail/{id}")
    @EnabledLoginValidate
    public PicaResponse<HospitalRoleDto> getRoleDetail(@PathVariable("id") Long id) {
        return PicaResponse.toResponse(hospitalSaasRoleService.getRoleDetail(id));
    }
}