package com.pica.cloud.account.account.server.log;


import com.pica.cloud.account.account.server.entity.LogLoginEntity;
import com.pica.cloud.account.account.server.entity.LogPWDModifyEntity;
import com.pica.cloud.account.account.server.entity.LogUserInfoEntity;
import com.pica.cloud.account.account.server.enums.EnumsType;

import com.pica.cloud.account.account.server.mapper.LogLoginMapper;
import com.pica.cloud.account.account.server.mapper.LogPWDModifyMapper;
import com.pica.cloud.account.account.server.mapper.LogUserInfoMapper;
import com.pica.cloud.account.account.server.util.BeanUtil;
import com.pica.cloud.foundation.utils.utils.SpringContextUtil;
import org.springframework.beans.factory.annotation.Autowired;

public class PicaLogTask implements Runnable {

    private LogLoginMapper loginLogMapper;

    private LogPWDModifyMapper logPWDModifyMapper;

    private LogUserInfoMapper logUserInfoMapper;


    /**
     * 日志类型
     */
    private int type;

    /**
     * 日志内容
     */
    private PicaLogEntity picaLogEntity;

    PicaLogTask(PicaLogEntity picaLogEntity) {
        this.picaLogEntity = picaLogEntity;
        type = picaLogEntity.getLogType();
        loginLogMapper = BeanUtil.getBean(LogLoginMapper.class);
        logPWDModifyMapper = BeanUtil.getBean(LogPWDModifyMapper.class);
        logUserInfoMapper = BeanUtil.getBean(LogUserInfoMapper.class);
    }

    @Override
    public void run() {
        if (type == EnumsType.LOG_TYPE_LOGIN.getCode()) {
            loginLogMapper.insertSelective((LogLoginEntity) picaLogEntity);
        } else if (type == EnumsType.LOG_TYPE_PASSWORD.getCode()) {
            logPWDModifyMapper.insertSelective((LogPWDModifyEntity) picaLogEntity);
        } else if (type == EnumsType.LOG_TYPE_USER_INFO.getCode()) {
            logUserInfoMapper.insertSelective((LogUserInfoEntity) picaLogEntity);
        }
    }
}
