package com.pica.cloud.account.account.server.controller;

import com.pica.cloud.account.account.server.entity.AccountUser;
import com.pica.cloud.account.account.server.entity.EncryptEntity;
import com.pica.cloud.account.account.server.enums.EnumsType;
import com.pica.cloud.account.account.server.enums.ExceptionType;
import com.pica.cloud.account.account.server.req.BaseRequest;
import com.pica.cloud.account.account.server.service.ModifyMobileService;
import com.pica.cloud.account.account.server.util.AccountUtils;
import com.pica.cloud.account.account.server.util.CryptoUtil;
import com.pica.cloud.foundation.entity.PicaException;
import com.pica.cloud.foundation.entity.PicaResponse;
import com.sun.javafx.scene.control.skin.TableHeaderRow;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RestController;

@Api("修改手机号资源")
@RestController
public class ModifyMobileController extends AccountBaseController {

    @Autowired
    private AccountUtils accountUtils;

    @Autowired
    private ModifyMobileService modifyMobileService;

    @ApiOperation("修改手机号")
    @PostMapping("/mobile/modify")
    public PicaResponse modifyMobile(@RequestBody EncryptEntity entity) throws Exception {
        Integer acctId = null;
        try {
            AccountUser accountUser = super.getAccountUser();
            acctId = accountUser.getAcctId();
        } catch (Exception e) {
            e.printStackTrace();
            throw new PicaException(ExceptionType.PICA_LOGIN_AGAIN.getCode(), ExceptionType.PICA_LOGIN_AGAIN.getMessage());
        }
        BaseRequest request = CryptoUtil.decrypt(entity, BaseRequest.class);
        String mobile = request.getMobile();
        accountUtils.checkMobilePhone(mobile);
        accountUtils.checkAuthCode(mobile, EnumsType.SYSCODE_TYPE_MODIFY_MOBILE.getCode() + "", request.getSysCode());
        modifyMobileService.modify(acctId, mobile);
        return PicaResponse.toResponse("修改成功");
    }


}
