package com.pica.cloud.account.account.server.controller;

import com.pica.cloud.account.account.server.entity.AccountUser;
import com.pica.cloud.account.account.server.entity.EncryptEntity;
import com.pica.cloud.account.account.server.enums.EnumsType;
import com.pica.cloud.account.account.server.enums.ExceptionType;
import com.pica.cloud.account.account.server.req.BaseRequest;
import com.pica.cloud.account.account.server.service.PasswordService;
import com.pica.cloud.account.account.server.util.AccountUtils;
import com.pica.cloud.account.account.server.util.CryptoUtil;
import com.pica.cloud.foundation.entity.PicaException;
import com.pica.cloud.foundation.entity.PicaResponse;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api("密码资源")
@RestController
@RequestMapping("/password")
public class PasswordController extends AccountBaseController {

    @Autowired
    private PasswordService passwordService;

    @Autowired
    private AccountUtils accountUtils;


    /**
     * 修改密码
     *
     * @return
     */
    @ApiOperation("修改密码接口")
    @PostMapping(value = "/modify")
    public PicaResponse modifyPassword(@RequestBody EncryptEntity entity) throws Exception {
        Integer acctId = super.getAcctId();
        BaseRequest request = CryptoUtil.decrypt(entity, BaseRequest.class);
        String oldPwd = request.getOldPwd();
        String password = request.getPassword();
        if (!StringUtils.isEmpty(password) && !StringUtils.isEmpty(oldPwd)) {
            if (!password.equals(oldPwd)) {
                passwordService.modifyPassword(acctId, oldPwd, password);
                return PicaResponse.toResponse();
            } else {
                throw new PicaException(ExceptionType.PICA_PASSWORD_EQUAL.getCode(), ExceptionType.PICA_PASSWORD_EQUAL.getMessage());
            }
        } else {
            throw new PicaException(ExceptionType.PICA_PASSWORD_NULL.getCode(), ExceptionType.PICA_PASSWORD_NULL.getMessage());
        }
    }

    /**
     * 忘记密码
     *
     * @return
     */
    @ApiOperation("忘记密码接口")
    @PostMapping(value = "/reset")
    public PicaResponse forgetPassword(@RequestBody EncryptEntity entity) throws Exception {
        Integer acctId = super.getAcctId();
        BaseRequest request = CryptoUtil.decrypt(entity, BaseRequest.class);
        accountUtils.checkMobilePhone(request.getMobile());
        accountUtils.checkAuthCode(request.getMobile(), EnumsType.SYSCODE_TYPE_RESET_PASSWORD.getCode() + "", request.getSysCode());
        if (StringUtils.isEmpty(request.getPassword())) {
            throw new PicaException(ExceptionType.PICA_PASSWORD_ERROR.getCode(), ExceptionType.PICA_PASSWORD_ERROR.getMessage());
        }
        request.setAccId(acctId);
        passwordService.forgetPassword(request);
        return PicaResponse.toResponse();
    }
}
