package com.pica.cloud.account.account.server.service.impl;

import com.pica.cloud.account.account.server.entity.AccountInfoEntity;
import com.pica.cloud.account.account.server.entity.LogPWDModifyEntity;
import com.pica.cloud.account.account.server.enums.EnumsType;
import com.pica.cloud.account.account.server.enums.ExceptionType;
import com.pica.cloud.account.account.server.log.PicaLogUtils;
import com.pica.cloud.account.account.server.mapper.AccountInfoDetailMapper;
import com.pica.cloud.account.account.server.req.BaseRequest;
import com.pica.cloud.account.account.server.service.PasswordService;
import com.pica.cloud.foundation.entity.PicaException;
import com.pica.cloud.foundation.utils.utils.EncryptCreateUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Date;

@Service
public class PasswordServiceImpl implements PasswordService {

    @Autowired
    private AccountInfoDetailMapper accountInfoDetailMapper;

    @Autowired
    private PicaLogUtils picaLogUtils;

    @Override
    public void modifyPassword(Integer acctId, String oldPwd, String pwd) {
        AccountInfoEntity entity = accountInfoDetailMapper.selectByPrimaryKey(acctId);
        if (entity.getPassword().equals(EncryptCreateUtil.encrypt(oldPwd))) {
            AccountInfoEntity accountInfoEntity = new AccountInfoEntity();
            accountInfoEntity.setId(acctId);
            accountInfoEntity.setModifiedId(acctId);
            accountInfoEntity.setModifiedTime(new Date());
            accountInfoEntity.setPassword(EncryptCreateUtil.encrypt(pwd));
            accountInfoDetailMapper.updatePasswordByPrimaryKey(accountInfoEntity);
            //密码修改日志
            Date currentTime = new Date();
            LogPWDModifyEntity logPWDModifyEntity = new LogPWDModifyEntity();
            logPWDModifyEntity.setCreatedId(acctId);
            logPWDModifyEntity.setCreatedTime(currentTime);
            logPWDModifyEntity.setDeleteFlag(1);
            logPWDModifyEntity.setMobilePhone(entity.getMobilePhone());
            logPWDModifyEntity.setModifiedId(acctId);
            logPWDModifyEntity.setModifiedTime(currentTime);
            logPWDModifyEntity.setOldPwd(EncryptCreateUtil.encrypt(oldPwd));
            logPWDModifyEntity.setNewPwd(EncryptCreateUtil.encrypt(pwd));
            logPWDModifyEntity.setLogType(EnumsType.LOG_TYPE_PASSWORD.getCode());
            picaLogUtils.info(logPWDModifyEntity);
        } else {
            throw new PicaException(ExceptionType.PICA_PASSWORD_ERROR.getCode(), ExceptionType.PICA_PASSWORD_ERROR.getMessage());
        }
    }

    @Override
    public void forgetPassword(BaseRequest request) {
        Integer accId = request.getAccId();
        AccountInfoEntity accountInfoEntity = new AccountInfoEntity();
        accountInfoEntity.setId(accId);
        accountInfoEntity.setModifiedId(accId);
        accountInfoEntity.setModifiedTime(new Date());
        accountInfoEntity.setPassword(EncryptCreateUtil.encrypt(request.getPassword()));
        accountInfoDetailMapper.updatePasswordByPrimaryKey(accountInfoEntity);
        //密码修改日志
        Date currentTime = new Date();
        LogPWDModifyEntity logPWDModifyEntity = new LogPWDModifyEntity();
        logPWDModifyEntity.setCreatedId(accId);
        logPWDModifyEntity.setCreatedTime(currentTime);
        logPWDModifyEntity.setDeleteFlag(1);
        logPWDModifyEntity.setMobilePhone(request.getMobile());
        logPWDModifyEntity.setModifiedId(accId);
        logPWDModifyEntity.setModifiedTime(currentTime);
        logPWDModifyEntity.setOldPwd("");
        logPWDModifyEntity.setNewPwd(EncryptCreateUtil.encrypt(request.getPassword()));
        logPWDModifyEntity.setLogType(EnumsType.LOG_TYPE_PASSWORD.getCode());
        picaLogUtils.info(logPWDModifyEntity);
    }
}
