package com.pica.cloud.account.account.server.enums;

public enum ExceptionType {

    PICA_NOT_EMPTY("216501", "字段非空提示信息"),
    PICA_MOBILE_ERROR("216502", "请输入正确的手机号"),
    PICA_SYSCODE_ERROR("216503", "短信验证码错误"),
    PICA_SYSCODE_EXPIRE("216504", "短信验证码已过期，请重新获取"),
    PICA_SYSCODE_RESET("216505", "请X秒后重试（获取验证码），请重新获取"),
    PICA_SYSCODE_LATER("216506", "验证码获取过于频繁，请隔天后重试"),
    PICA_ALREADY_REGISTER("216507", "该手机号已注册，请直接登录"),
    PICA_NOT_REGISTER("216508", "未注册,请先注册"),
    PICA_PASSWORD_ERROR("216509", "请输入正确的密码"),
    PICA_IMAGE_PASSWORD_ERROR("216511", "图形验证码错误"),
    PICA_LOGIN_AGAIN("216512", "请重新登录"),
    PICA_PASSWORD_NULL("216513", "密码不能为空"),
    PICA_PASSWORD_EQUAL("216514", "旧密码与新密码不能相同");


    private String code;
    private String message;

    ExceptionType(String code, String message) {
        this.code = code;
        this.message = message;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getMessage() {
        return message;
    }

    public void setMessage(String message) {
        this.message = message;
    }
}

