package com.pica.cloud.account.account.server.service.impl;

import com.pica.cloud.account.account.common.req.circle.CircleAcctInit;
import com.pica.cloud.account.account.common.req.circle.CircleAcctInitReq;
import com.pica.cloud.account.account.server.entity.Account;
import com.pica.cloud.account.account.server.mapper.AccountMapper;
import com.pica.cloud.account.account.server.service.CircleAccountService;
import com.pica.cloud.account.account.server.service.AccountService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;


/**
 * @DESCRIPTOIN:
 * @AUTHOR: joy
 * @DATE:2020/6/21 10:25 上午
 */
@Service
public class CircleAccountServiceImpl implements CircleAccountService {

    @Autowired
    private AccountService accountService;

    @Autowired
    private AccountMapper accountMapper;

    @Override
    public List<Integer> createCircleAccount(CircleAcctInitReq circleAcctInitReq) {
        List<CircleAcctInit> circleAcctInits = circleAcctInitReq.getCircleAcctInitList();
        List<Integer> savedIds = new ArrayList<>();
        for(CircleAcctInit acct : circleAcctInits){
            Account dbAcct = accountMapper.getByMobilePhone(acct.getEncryMobile());  //获取医生表账号信息
            if(null == dbAcct){
                Account account = new Account();
                account.setNickname(acct.getUserName());
                account.setMobilePhone(acct.getEncryMobile());
                account.setRegisterSource(circleAcctInitReq.getRegisterSource());
                accountService.createAccount(account);
                savedIds.add(account.getId().intValue());
            }else {
                savedIds.add(dbAcct.getId().intValue());
            }
        }
        return savedIds;
    }

}
