package com.pica.cloud.account.account.server.service;

import com.pica.cloud.account.account.server.util.captcha.CaptchaToken;

/**
 * @author Laurence Cao
 *
 */
public interface CaptchaService {

    /**
     * 生成验证码的令牌及图片(json时为base64编码)
     * 
     * @return
     */
    CaptchaToken generateToken(int width, int height);

    /**
     * 确认令牌与回答字符串是一致的，无论成功与否都将失效令牌
     * 
     * @param token
     * @param answer
     * @return
     */
    boolean acknowledge(String token, String answer);

}
