package com.pica.cloud.account.account.client;

import com.pica.cloud.account.account.common.dto.CancelAccountDto;
import com.pica.cloud.account.account.common.dto.QueryDoctorRole;
import com.pica.cloud.foundation.entity.PicaResponse;
import org.springframework.cloud.netflix.feign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;

/**
 * @author andong
 * @create 2019/7/19
 */
@FeignClient(name = "13201-pica-cloud-account")
public interface AccountDoctorClient {

    @PostMapping("/account/doctor/cancel/account")
    PicaResponse<Void> cancelAccountByDoctorId(@RequestBody CancelAccountDto cancelAccountDto, @RequestHeader(value = "token") String token);

    @PostMapping("/account/doctor/queryDoctorExistRole")
    PicaResponse<Boolean> queryDoctorExistRole(@RequestBody QueryDoctorRole req);
}
