package com.pica.cloud.account.account.server.queue;

import org.springframework.amqp.core.AmqpTemplate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

/**
 * Created on 2019/9/11 17:37
 * author:crs
 * Description:消息生产者
 */
@Component
public class QueueProducer {

    @Autowired
    private AmqpTemplate amqpTemplate;

    /**
     * 发送消息
     *
     * @param message
     */
    public void send(byte[] message) {
        amqpTemplate.convertAndSend(QueueConfig.EXCHANGE_NAME, QueueConfig.ROUTE_KEY_NAME, message);
    }
}
