package com.pica.cloud.account.account.server.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.pica.cloud.account.account.server.constants.Constants;
import com.pica.cloud.account.account.server.entity.Account;
import com.pica.cloud.account.account.server.entity.AccountInfoEntity;
import com.pica.cloud.account.account.server.entity.AccountPatientInfoEntity;
import com.pica.cloud.account.account.server.entity.LogLoginEntity;
import com.pica.cloud.account.account.server.enums.AccountExceptionEnum;
import com.pica.cloud.account.account.server.enums.AccountTypeEnum;
import com.pica.cloud.account.account.server.exception.AccountException;
import com.pica.cloud.account.account.server.log.AccountLogEntityUtils;
import com.pica.cloud.account.account.server.log.AccountLogUtils;
import com.pica.cloud.account.account.server.mapper.AccountInfoDetailMapper;
import com.pica.cloud.account.account.server.mapper.AccountMapper;
import com.pica.cloud.account.account.server.mapper.AccountPatientInfoMapper;
import com.pica.cloud.account.account.server.queue.QueueProducer;
import com.pica.cloud.account.account.server.req.BaseRequest;
import com.pica.cloud.account.account.server.service.RegisterService;
import com.pica.cloud.account.account.server.util.AESUtil;
import com.pica.cloud.account.account.server.util.AccountUtils;
import com.pica.cloud.account.account.server.util.TokenUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Date;

@Service
public class RegisterServiceImpl implements RegisterService {

    @Autowired
    private AccountInfoDetailMapper accountInfoDetailMapper;

    @Autowired
    private AccountPatientInfoMapper accountUserInfoMapper;

    @Autowired
    private AccountMapper accountMapper;

    @Autowired
    private AccountLogUtils picaLogUtils;

    @Autowired
    private AccountUtils accountUtils;

    @Autowired
    private TokenUtils tokenUtils;

    @Autowired
    private QueueProducer queueProducer;

    /**
     * 1)注册功能：默认未完善信息；
     * 2)注册成功后发送mq消息，让别的服务初始化数据；
     * 3)记录登录日志;
     *
     * @param baseRequest 参数模型
     * @return
     */
    @Override
    public String register(BaseRequest baseRequest) {
        String mobile = baseRequest.getMobile();
        String mobileEncrypt = AESUtil.encryptV0(mobile);
        AccountInfoEntity accountInfoEntity = accountInfoDetailMapper.selectByMobile(mobileEncrypt);
        if (accountInfoEntity == null) {
            Date currentTime = new Date();
            int productType = baseRequest.getProductType();
            int sourceType = baseRequest.getSourceType();
            String password = baseRequest.getPassword();
            AccountInfoEntity accountInfo = new AccountInfoEntity();
            accountInfo.setMobilePhone(mobileEncrypt);
            if (StringUtils.isEmpty(password)) {
                password = "";
            }
            accountInfo.setPassword(password);
            accountInfo.setCreatedTime(currentTime);
            accountInfo.setCreatedId(0);
            accountInfo.setModifiedId(0);
            accountInfo.setModifiedTime(currentTime);
            accountInfo.setRegTime(currentTime);
            accountInfo.setDeleteFlag(1);
            accountInfo.setSex(0);
            accountInfo.setRegisterProduct(productType);
            accountInfo.setRegisterSource(sourceType);
            accountInfoDetailMapper.insertSelective(accountInfo);
            Integer acctId = accountInfo.getId();
            accountInfoDetailMapper.updateCreateInfo(acctId);
            if (productType == AccountTypeEnum.PRODUCT_TYPE_HEALTH.getCode()) {
                AccountPatientInfoEntity accountPatientInfoEntity = new AccountPatientInfoEntity();
                accountPatientInfoEntity.setAcctId(acctId);
                accountPatientInfoEntity.setDeleteFlag(1);
                accountPatientInfoEntity.setCreateId(acctId);
                accountPatientInfoEntity.setModifyId(acctId);
                accountPatientInfoEntity.setCreateTime(currentTime);
                accountPatientInfoEntity.setModifyTime(currentTime);
                accountUserInfoMapper.insertSelective(accountPatientInfoEntity);
            } else {
                Account account = new Account();
                account.setAcctId(acctId);
                account.setMobilePhone(mobileEncrypt);
                account.setDeleteFlag(1);
                account.setCreatId(0L);
                account.setModifyId(0L);
                account.setCreatTime(currentTime);
                account.setModifyTime(currentTime);
                account.setFirstLoginTime(currentTime);
                account.setLastLoginTime(currentTime);
                account.setPassword(password);
                accountMapper.insertSelective(account);
            }
            Long userId = accountUtils.getUserIdByAcctId(productType, acctId);
            Account account = new Account();
            account.setId(userId);
            account.setAcctId(acctId);
            account.setCreatTime(currentTime);
            account.setMobilePhone(mobile);
            account.setRegisterSource(sourceType);
            String newToken = tokenUtils.generateToken(account);
            JSONObject jsonObject = new JSONObject();
            jsonObject.put(Constants.TOKEN, newToken);
            jsonObject.put(Constants.USER_ID, userId);
            jsonObject.put(Constants.USER_ENTIRE_FLAG, 1);
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            DataOutputStream dos = new DataOutputStream(bos);
            try {
                dos.writeLong(userId);
            } catch (IOException e) {
                e.printStackTrace();
            }
            queueProducer.send(bos.toByteArray());
            LogLoginEntity entity = AccountLogEntityUtils.getLogLoginEntity(acctId, productType, baseRequest.getSourceType(),
                    AccountTypeEnum.LOGIN_REGISTER.getCode(), baseRequest.getLoginIp(), AccountTypeEnum.LOGIN_STATUS_SUCCESS.getCode(),
                    AccountTypeEnum.LOG_TYPE_LOGIN.getCode());
            picaLogUtils.info(entity);
            return jsonObject.toJSONString();
        } else {
            throw new AccountException(AccountExceptionEnum.PICA_ALREADY_REGISTER);
        }
    }
}
