package com.pica.cloud.account.account.server.controller;

import com.pica.cloud.account.account.server.entity.EncryptEntity;
import com.pica.cloud.account.account.server.enums.AccountEnumType;
import com.pica.cloud.account.account.server.req.BaseRequest;
import com.pica.cloud.account.account.server.service.RegisterService;
import com.pica.cloud.account.account.server.util.AccountUtils;
import com.pica.cloud.account.account.server.util.CryptoUtil;
import com.pica.cloud.foundation.entity.PicaResponse;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(description="注册资源")
@RestController
@RequestMapping("/register")
public class RegisterController extends AccountBaseController {

    @Autowired
    private RegisterService registerService;

    @ApiOperation("注册接口")
    @PostMapping(value = "")
    public PicaResponse<String> register(@RequestBody EncryptEntity entity) throws Exception {
        BaseRequest request = CryptoUtil.decrypt(entity, BaseRequest.class);
        AccountUtils.checkMobilePhone(request.getMobile());
        AccountUtils.getAuthCodeKey(request.getSysCode(), AccountEnumType.SYSCODE_TYPE_REGISTER.getCode() + "");
        AccountUtils.checkPassword(request.getPassword());
        request.setFlag(AccountEnumType.SYSCODE_TYPE_REGISTER.getCode());
        request.setProductType(super.getProductType());
        request.setSourceType(super.getSourceType());
        request.setLoginIp(super.getIpAddr());
        String result = registerService.register(request);
        return PicaResponse.toResponse(result);
    }
}
