package com.pica.cloud.account.account.server.service.impl;

import com.pica.cloud.account.account.server.entity.AccountUserInfoEntity;
import com.pica.cloud.account.account.server.entity.LogUserInfoEntity;
import com.pica.cloud.account.account.server.log.AccountLogUtils;
import com.pica.cloud.account.account.server.mapper.AccountUserInfoMapper;
import com.pica.cloud.account.account.server.service.UserInfoService;
import org.apache.commons.beanutils.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.lang.reflect.InvocationTargetException;
import java.util.Date;

@Service
public class UserInfoServerImpl implements UserInfoService {

    @Autowired
    private AccountUserInfoMapper accountUserInfoMapper;

    @Autowired
    private AccountLogUtils accountLogUtils;

    @Override
    public void updateUserInfo(AccountUserInfoEntity accountUserInfoEntity) {
        accountUserInfoEntity.setModifyTime(new Date());
        accountUserInfoEntity.setModifyId(accountUserInfoEntity.getAcctId());
        accountUserInfoMapper.updateByPrimaryKeySelective(accountUserInfoEntity);
        //用户信息更新日志
        Integer userId = accountUserInfoEntity.getId();
        AccountUserInfoEntity userInfo = getUserInfo(userId);
        LogUserInfoEntity logUserInfoEntity = new LogUserInfoEntity();
        try {
            BeanUtils.copyProperties(logUserInfoEntity, userInfo);
            Date currentTime = new Date();
            logUserInfoEntity.setCreateTime(currentTime);
            logUserInfoEntity.setModifyTime(currentTime);
            accountLogUtils.info(logUserInfoEntity);
        } catch (IllegalAccessException e) {
            e.printStackTrace();
        } catch (InvocationTargetException e) {
            e.printStackTrace();
        }
    }

    @Override
    public AccountUserInfoEntity getUserInfo(Integer userId) {
        return accountUserInfoMapper.selectByUserId(userId);
    }
}
