package com.pica.cloud.account.account.server.log;

import com.pica.cloud.account.account.server.entity.LogLoginEntity;
import com.pica.cloud.account.account.server.entity.LogPWDModifyEntity;

import java.util.Date;

public class AccountLogEntityUtils {

    /**
     * 获取登录日志实例
     *
     * @param acctId
     * @param productType
     * @param sourceType
     * @return
     */
    public static LogLoginEntity getLogLoginEntity(Integer acctId, Integer productType, Integer sourceType) {
        LogLoginEntity entity = new LogLoginEntity();
        Date currentTime = new Date();
        entity.setAcctId(acctId);
        entity.setCreateId(acctId);
        entity.setCreateTime(currentTime);
        entity.setModifyId(acctId);
        entity.setModifyTime(currentTime);
        entity.setDeleteFlag(1);
        entity.setLoginTime(currentTime);
        entity.setProductType(productType);
        entity.setSourceType(sourceType);
        return entity;
    }

    /**
     * 获取密码修改实例
     *
     * @param acctId
     * @return
     */
    public static LogPWDModifyEntity getLogPWDModifyEntity(Integer acctId) {
        LogPWDModifyEntity entity = new LogPWDModifyEntity();
        Date currentTime = new Date();
        entity.setCreatedId(acctId);
        entity.setCreatedTime(currentTime);
        entity.setDeleteFlag(1);
        entity.setModifiedId(acctId);
        entity.setModifiedTime(currentTime);
        return entity;
    }


}
