package com.pica.cloud.account.account.server.service.impl;


import com.alibaba.fastjson.JSONObject;
import com.pica.cloud.account.account.server.constants.Constants;
import com.pica.cloud.account.account.server.entity.*;
import com.pica.cloud.account.account.server.enums.AccountEnumType;
import com.pica.cloud.account.account.server.enums.AccountExceptionType;
import com.pica.cloud.account.account.server.log.AccountLogEntityUtils;
import com.pica.cloud.account.account.server.log.AccountLogUtils;
import com.pica.cloud.account.account.server.mapper.AccountInfoDetailMapper;
import com.pica.cloud.account.account.server.mapper.AccountUnionMapper;
import com.pica.cloud.account.account.server.mapper.AccountUserInfoMapper;
import com.pica.cloud.account.account.server.mapper.AccountWeChatInfoMapper;
import com.pica.cloud.account.account.server.req.AccountReq;
import com.pica.cloud.account.account.server.req.BaseRequest;
import com.pica.cloud.account.account.server.service.LoginService;
import com.pica.cloud.account.account.server.service.RegisterService;
import com.pica.cloud.account.account.server.util.AccountUtils;
import com.pica.cloud.account.account.server.util.TokenUtils;
import com.pica.cloud.account.account.server.util.WeChatUtils;
import com.pica.cloud.foundation.entity.PicaException;
import com.pica.cloud.foundation.entity.PicaResultCode;
import com.pica.cloud.foundation.redis.ICacheClient;
import com.pica.cloud.foundation.utils.utils.EncryptCreateUtil;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;

@Service
public class LoginServiceImpl implements LoginService {

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private AccountInfoDetailMapper accountInfoDetailMapper;

    @Autowired
    private AccountUserInfoMapper accountUserInfoMapper;

    @Autowired
    private AccountUnionMapper accountUnionMapper;

    @Autowired
    private AccountWeChatInfoMapper accountWeChatInfoMapper;

    @Autowired
    private AccountLogUtils picaLogUtils;

    @Autowired
    private TokenUtils tokenUtils;

    @Autowired
    private RegisterService registerService;

    @Autowired
    @Qualifier("cacheMigrateClient")
    private ICacheClient redisClient;

    @Value("${weChatAppID}")
    private String appId;
    @Value("${weChatAppSecret}")
    private String appSecret;
    @Value("${weChatURL}")
    private String weChatURL;

    @Override
    public String login(BaseRequest request) {
        String mobile = request.getMobile();
        AccountInfoEntity accountInfoEntity = accountInfoDetailMapper.selectByMobile(EncryptCreateUtil.encrypt(mobile));
        if (accountInfoEntity != null) {
            String oldPwd = accountInfoEntity.getPassword();
            String password = request.getPassword();
            if (password.equals(EncryptCreateUtil.dencrypt(oldPwd))) {
                //登陆成功，返回新的token
                //通过账户id查询用户id
                Date currentTime = new Date();
                Integer acctId = accountInfoEntity.getId();
                AccountUserInfoEntity accountUserInfoEntity = accountUserInfoMapper.selectByAcctId(acctId);
                int productType = request.getProductType();
                int sourceType = request.getSourceType();
                Account account = new Account();
                account.setId(accountUserInfoEntity.getId().longValue());
                account.setAcctId(acctId);
                account.setCreatTime(currentTime);
                account.setMobilePhone(mobile);
                account.setRegisterSource(sourceType);
                String newToken = tokenUtils.generateToken(account);
                JSONObject jsonObject = new JSONObject();
                jsonObject.put(Constants.TOKEN, newToken);
                jsonObject.put(Constants.USER_ID, accountUserInfoEntity.getId().longValue());
                //记录登录日志
                LogLoginEntity entity = AccountLogEntityUtils.getLogLoginEntity(acctId, productType, request.getSourceType());
                entity.setLoginType(AccountEnumType.LOGIN_PWD.getCode());
                entity.setLoginIp(request.getLoginIp());
                entity.setLoginStatus(AccountEnumType.LOGIN_STATUS_SUCCESS.getCode());
                entity.setLogType(AccountEnumType.LOG_TYPE_LOGIN.getCode());
                picaLogUtils.info(entity);
                return jsonObject.toJSONString();
            } else {
                logger.info("login failure：" + mobile);
                throw new PicaException(AccountExceptionType.PICA_PASSWORD_ERROR.getCode(), AccountExceptionType.PICA_PASSWORD_ERROR.getMessage());
            }
        } else {
            throw new PicaException(AccountExceptionType.PICA_NOT_REGISTER.getCode(), AccountExceptionType.PICA_NOT_REGISTER.getMessage());
        }
    }


    @Override
    public String loginAndRegister(BaseRequest baseRequest) {
        String mobile = baseRequest.getMobile();
        AccountInfoEntity accountInfoEntity = accountInfoDetailMapper.selectByMobile(EncryptCreateUtil.encrypt(mobile));
        if (accountInfoEntity == null) {
            return registerService.register(baseRequest);
        } else {
            return processLogin(baseRequest, accountInfoEntity.getId(), AccountEnumType.LOGIN_CODE.getCode());
        }
    }

    /**
     * 登录逻辑处理
     *
     * @param baseRequest
     */
    private String processLogin(BaseRequest baseRequest, Integer acctId, Integer loginType) {
        Date currentTime = new Date();
        AccountUserInfoEntity accountUserInfoEntity = accountUserInfoMapper.selectByAcctId(acctId);
        //验证码登陆：只要相同即可成功
        AccountReq accountReq = new AccountReq();
        accountReq.setAuthCode(baseRequest.getSysCode());
        accountReq.setMobilePhone(baseRequest.getMobile());
        accountReq.setFlag("0");
        checkAuthCode(accountReq);
        Account account = new Account();
        account.setId(accountUserInfoEntity.getId().longValue());
        account.setAcctId(acctId);
        account.setCreatTime(currentTime);
        account.setMobilePhone(baseRequest.getMobile());
        account.setRegisterSource(baseRequest.getSourceType());
        String newToken = tokenUtils.generateToken(account);
        JSONObject jsonObject = new JSONObject();
        jsonObject.put(Constants.TOKEN, newToken);
        jsonObject.put(Constants.USER_ID, accountUserInfoEntity.getId().longValue());
        //记录登录日志
        LogLoginEntity entity = AccountLogEntityUtils.getLogLoginEntity(acctId, baseRequest.getProductType(), baseRequest.getSourceType());
        entity.setLoginType(loginType);
        entity.setLoginIp(baseRequest.getLoginIp());
        entity.setLoginStatus(AccountEnumType.LOGIN_STATUS_SUCCESS.getCode());
        entity.setLogType(AccountEnumType.LOG_TYPE_LOGIN.getCode());
        picaLogUtils.info(entity);
        return jsonObject.toJSONString();
    }

    @Override
    public String loginByWeChat(BaseRequest request) {
        WeChatEntity weChatEntity = WeChatUtils.getAuthorizationInfo(appId, appSecret, request.getWeChatCode());
        //todo：微信登录获取个人信息
        Map map = new HashMap();
        map.put("access_token", weChatEntity.getAccess_token());
        map.put("openid", weChatEntity.getOpenid());
        Map weChatUserInfo = WeChatUtils.getWeChatUserInfo(map, weChatURL);
        WeChatUserInfoEntity weChatUserInfoEntity = WeChatUtils.mergeWechatUserInfo(weChatUserInfo, weChatEntity.getOpenid());
        String unionId = weChatUserInfoEntity.getUnionid();
        AccountUnionEntity accountUnionEntity = accountUnionMapper.selectByUnionId(unionId);
        if (accountUnionEntity != null) {
            //是否绑定逻辑的判断
            Long acctId = accountUnionEntity.getAcctId();
            AccountUserInfoEntity accountUserInfoEntity = accountUserInfoMapper.selectByAcctId(acctId.intValue());
            Account account = new Account();
            account.setId(accountUserInfoEntity.getId().longValue());
            account.setAcctId(acctId.intValue());
            account.setCreatTime(new Date());
            account.setMobilePhone(request.getMobile());
            account.setRegisterSource(request.getSourceType());
            String newToken = tokenUtils.generateToken(account);
            JSONObject jsonObject = new JSONObject();
            jsonObject.put(Constants.TOKEN, newToken);
            jsonObject.put(Constants.USER_ID, accountUserInfoEntity.getId().longValue());
            jsonObject.put(Constants.BIND_FLAG, AccountEnumType.BIND_STATUS_SUCCESS.getCode());
            return jsonObject.toJSONString();
        } else {
            AccountWeChatInfoEntity entity = accountWeChatInfoMapper.selectByUnionId(unionId);
            if (entity == null) {
                processWeChatInfoUser(weChatUserInfoEntity, request.getWeChatLoginType());
            }
            JSONObject jsonObject = new JSONObject();
            jsonObject.put(Constants.BIND_FLAG, AccountEnumType.BIND_STATUS_FAILURE.getCode());
            jsonObject.put(Constants.UNION_ID, unionId);
            return jsonObject.toJSONString();
        }
    }

    @Override
    public String loginByWeChatStep(BaseRequest request) {
        //判断当前手机号是否注册过,注册过，直接登录；没有注册过，进行注册操操作
        AccountInfoEntity accountInfoEntity = accountInfoDetailMapper.selectByMobile(EncryptCreateUtil.encrypt(request.getMobile()));
        String json;
        if (accountInfoEntity == null) {
            json = registerService.register(request);
        } else {
            json = processLogin(request, accountInfoEntity.getId(), AccountEnumType.LOGIN_WE_CHAT.getCode());
        }
        AccountInfoEntity accountInfo = accountInfoDetailMapper.selectByMobile(EncryptCreateUtil.encrypt(request.getMobile()));
        Integer acctId = accountInfo.getId();
        processAccountUnion(acctId, request.getUnionId());
        return json;
    }

    @Override
    public void unbindWeChat(Integer acctId) {
        accountUnionMapper.updateUnbindByAcctId(acctId);
    }

    @Override
    public void bindWeChat(BaseRequest request) {
        WeChatEntity weChatEntity = WeChatUtils.getAuthorizationInfo(appId, appSecret, request.getWeChatCode());
        Map map = new HashMap();
        map.put("access_token", weChatEntity.getAccess_token());
        map.put("openid", weChatEntity.getOpenid());
        Map weChatUserInfo = WeChatUtils.getWeChatUserInfo(map, weChatURL);
        WeChatUserInfoEntity weChatUserInfoEntity = WeChatUtils.mergeWechatUserInfo(weChatUserInfo, weChatEntity.getOpenid());
        String unionId = weChatUserInfoEntity.getUnionid();
        AccountWeChatInfoEntity entity = accountWeChatInfoMapper.selectByUnionId(unionId);
        if (entity == null) {
            processWeChatInfoUser(weChatUserInfoEntity, request.getWeChatLoginType());
        }
        processAccountUnion(request.getAccId(), unionId);
    }


    private void processAccountUnion(Integer acctId, String unionId) {
        AccountUnionEntity accountUnionEntity = new AccountUnionEntity();
        accountUnionEntity.setAcctId(acctId.longValue());
        accountUnionEntity.setDeleteFlag(1);
        accountUnionEntity.setUnionId(unionId);
        accountUnionEntity.setCreatedTime(new Date());
        accountUnionEntity.setModifiedTime(new Date());
        accountUnionEntity.setCreatedId(acctId);
        accountUnionEntity.setModifiedId(acctId);
        accountUnionEntity.setUnionType(AccountEnumType.UNION_LOGIN_WE_CHAT.getCode());
        accountUnionMapper.insertSelective(accountUnionEntity);
    }

    private void processWeChatInfoUser(WeChatUserInfoEntity weChatUserInfoEntity, int type) {
        AccountWeChatInfoEntity accountWeChatInfoEntity = new AccountWeChatInfoEntity();
        Date currentTime = new Date();
        accountWeChatInfoEntity.setCreatedId(0);
        accountWeChatInfoEntity.setCreatedTime(currentTime);
        accountWeChatInfoEntity.setDeleteFlag(1);
        accountWeChatInfoEntity.setGroupid(weChatUserInfoEntity.getGroupid() + "");
        accountWeChatInfoEntity.setType(type);
        accountWeChatInfoEntity.setModifiedId(0);
        accountWeChatInfoEntity.setModifiedTime(currentTime);
        accountWeChatInfoEntity.setOpenid(weChatUserInfoEntity.getOpenid());
        accountWeChatInfoEntity.setUnionid(weChatUserInfoEntity.getUnionid());
        accountWeChatInfoEntity.setPrivilege(weChatUserInfoEntity.getPrivilege());
        accountWeChatInfoEntity.setRemark(weChatUserInfoEntity.getRemark());
        accountWeChatInfoEntity.setSubscribe(weChatUserInfoEntity.getSubscribe());
        accountWeChatInfoEntity.setSubscribeTime(weChatUserInfoEntity.getSubscribe_time());
        accountWeChatInfoEntity.setTagidList(weChatUserInfoEntity.getTagid_list());
        accountWeChatInfoEntity.setCity(weChatUserInfoEntity.getCity());
        accountWeChatInfoEntity.setNickname(weChatUserInfoEntity.getNickname());
        accountWeChatInfoEntity.setHeadImgUrl(weChatUserInfoEntity.getHeadimgurl());
        accountWeChatInfoEntity.setCountry(weChatUserInfoEntity.getCountry());
        accountWeChatInfoEntity.setSex(weChatUserInfoEntity.getSex());
        accountWeChatInfoEntity.setProvince(weChatUserInfoEntity.getProvince());
        accountWeChatInfoEntity.setLanguage(weChatUserInfoEntity.getLanguage());
        accountWeChatInfoMapper.insertSelective(accountWeChatInfoEntity);

    }

    //校验验证码
    private void checkAuthCode(AccountReq req) {
        String flag = StringUtils.isBlank(req.getFlag()) ? "0" : req.getFlag();

        if (StringUtils.isBlank(req.getAuthCode())) {
            throw new PicaException(PicaResultCode.PARAM_IS_INVALID.code(), "短信验证码错误");
        }

        String authCodeKey = AccountUtils.getAuthCodeKey(req.getMobilePhone(), flag);
        String cacheCode = redisClient.get(authCodeKey);  //从redis获取验证码
        if (StringUtils.isBlank(cacheCode)) {
            throw new PicaException(PicaResultCode.RESULE_DATA_NONE.code(), "短信验证码已过期，请重新获取");
        }
        if (!StringUtils.equals(req.getAuthCode(), cacheCode)) {
            throw new PicaException(PicaResultCode.PARAM_IS_INVALID.code(), "短信验证码错误");
        }
        //清除验证码
        redisClient.del(authCodeKey);
    }
}
