package com.pica.cloud.account.account.server.service.impl;

import com.pica.cloud.account.account.server.entity.AccountWeChatInfoEntity;
import com.pica.cloud.account.account.server.mapper.AccountWeChatInfoMapper;
import com.pica.cloud.account.account.server.mapper.DoctorMapper;
import com.pica.cloud.account.account.server.service.WechatService;
import com.pica.cloud.foundation.utils.entity.PicaUser;
import com.pica.cloud.foundation.utils.utils.StringUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.HashMap;
import java.util.List;
import java.util.Map;


@Service
public class WechatServiceImpl implements WechatService {

    @Autowired
    private DoctorMapper doctorMapper;

    @Autowired
    private AccountWeChatInfoMapper weChatInfoMapper;

    @Override
    public AccountWeChatInfoEntity getAccountWechatInfo(PicaUser user) {
        String unionId = doctorMapper.getUnionIdByDoctorId(user.getId());
        if(StringUtil.isEmpty(unionId)){
            return null;
        }else {
            return weChatInfoMapper.selectByUnionId(unionId);
        }
    }

    @Override
    public Map<Integer, String> getAccountWechatInfoBatch(List<Integer> docIds, PicaUser user) {
        Map<Integer, String> rtnMap = new HashMap<>();
        for(Integer i : docIds){
            String openId = "";
            String unionId = doctorMapper.getUnionIdByDoctorId(user.getId());
            if(StringUtil.isEmpty(unionId)){
                rtnMap.put(i,"");
            }else {
                AccountWeChatInfoEntity rs = weChatInfoMapper.selectByUnionId(unionId);
                if(null != rs){
                    openId = rs.getOpenid();
                }
                rtnMap.put(i,openId);
            }
        }
        return rtnMap;
    }
}
