package com.pica.cloud.account.account.server.enums;

/**
 * Created on 2019/8/27
 * author:crs
 * Description:账户常用异常类型定义
 */
public enum AccountExceptionEnum {

    PICA_NOT_EMPTY("216501", "字段非空提示信息"),
    PICA_MOBILE_ERROR("216502", "请输入正确的手机号"),
    PICA_SYSCODE_ERROR("216503", "短信验证码错误"),
    PICA_SYSCODE_EXPIRE("216504", "短信验证码已过期，请重新获取"),
    PICA_SYSCODE_RESET("216505", "请X秒后重试（获取验证码），请重新获取"),
    PICA_SYSCODE_LATER("216506", "验证码获取过于频繁，请隔天后重试"),
    PICA_ALREADY_REGISTER("216507", "该手机号已注册，请直接登录"),
    PICA_NOT_REGISTER("216508", "未注册,请先注册"),
    PICA_PASSWORD_ERROR("216509", "请输入正确的密码"),
    PICA_IMAGE_PASSWORD_ERROR("216511", "图形验证码错误"),
    PICA_LOGIN_AGAIN("216512", "请重新登录"),
    PICA_PASSWORD_NULL("216513", "密码不能为空"),
    PICA_PASSWORD_EQUAL("216514", "旧密码与新密码不能相同"),
    PICA_UNBIND_MOBILE("216515", "该手机号未绑定微信"),
    PICA_MOBILE_SAME("216516", "新手机号与旧手机号不能相同"),
    PICA_PARAMS_ERROR("216517", "传递参数有误"),
    PICA_SYSCODE_RETRY("216518", "请X秒后重试"),
    PICA_NOT_EXIST("216519", "该用户不存在"),
    PICA_REGISTER_FAIL("216520", "注册失败"),
    PICA_WECHAT_CODE_ERROR("216521", "微信登录授权code不正确"),
    PICA_WECHAT_UNBIND("216522", "该微信号已绑定其他云鹊医账户，你可以使用微信登录云鹊医，在「设置」页解除绑定"),
    PICA_WECHAT_UNBIND_CURRENT("216523", "正在绑定中,请稍等");


    private String code;
    private String message;

    AccountExceptionEnum(String code, String message) {
        this.code = code;
        this.message = message;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getMessage() {
        return message;
    }

    public void setMessage(String message) {
        this.message = message;
    }
}

