package com.pica.cloud.account.account.server.util;

import com.pica.cloud.account.account.server.entity.Account;
import com.pica.cloud.foundation.redis.ICacheClient;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.UUID;

/**
 * Token工具类
 */
@Component
public class TokenUtils {

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    @Qualifier("cacheMigrateClient")
    private ICacheClient cacheClient;


    /**
     * 校验token的状态
     *
     * @param token
     * @return
     */
    public boolean checkTokenStatus(String token) {
        String str = cacheClient.get("token-" + token);
        return StringUtils.isBlank(str);
    }

    /**
     * 获取新的token
     *
     * @param account
     * @return
     */
    public String generateToken(Account account) {
        Integer registerSource = account.getRegisterSource();
        String newToken = "";
        try {
            //用户id
            String value = "token-doctor-" + account.getId().toString();
            // 根据不同的产品线设置token有效期
            int expiredSeconds = 24 * 60 * 60;
            if (registerSource != 3 && registerSource != 5) {
                expiredSeconds = expiredSeconds * 30;
            }
            newToken = UUID.randomUUID().toString().replace("-", "").toUpperCase();
            String Key = "token-" + newToken;
            //存储token对应的用户id，数据结构如：(token-FF9FCB0D93A642328A01C279701B7607：token-doctor-1)
            cacheClient.set(Key, value, expiredSeconds);
            //存储不同终端对应的token，数据结构如：(token-doctor-12345678-app：token-FF9FCB0D93A642328A01C279701B7607)
            String sourceType = AccountUtils.getSourceType(registerSource);
            cacheClient.set(value + "-" + sourceType, Key, expiredSeconds);
            //用户数据放入redis缓存
            String userData = cacheClient.hget(value, "id");
            if (org.apache.commons.lang3.StringUtils.isEmpty(userData)) {
                Map<String, String> data = new HashMap<>();
                data.put("token", newToken);
                data.put("id", account.getId() + "");
                data.put("acctId", account.getAcctId() + "");
                data.put("mobile", account.getMobilePhone());
                data.put("name", account.getMobilePhone().replaceAll("(\\d{3})\\d{4}(\\w{4})", "$1****$2"));
                data.put("created_time", new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(account.getCreatTime()));
                data.put("sysCode", sourceType);
                Iterator<Map.Entry<String, String>> iterator = data.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry<String, String> map = iterator.next();
                    String key = map.getKey();
                    String valueInfo = map.getValue();
                    //存储token：(token-doctor-1：用户数据)
                    cacheClient.hset(value, key, valueInfo);
                }
            } else {
                cacheClient.hset(value, "token", newToken);
            }
        } catch (Exception ex) {
            logger.error("生成token异常：{}" + ex.getMessage(), ex);
        }
        return newToken;
    }
}
