package com.pica.cloud.account.account.server.service.impl;

import com.pica.cloud.account.account.server.entity.AccountInfoEntity;
import com.pica.cloud.account.account.server.entity.LogPWDModifyEntity;
import com.pica.cloud.account.account.server.enums.AccountEnumType;
import com.pica.cloud.account.account.server.enums.AccountExceptionType;
import com.pica.cloud.account.account.server.exception.AccountException;
import com.pica.cloud.account.account.server.log.AccountLogEntityUtils;
import com.pica.cloud.account.account.server.log.AccountLogUtils;
import com.pica.cloud.account.account.server.mapper.AccountInfoDetailMapper;
import com.pica.cloud.account.account.server.req.BaseRequest;
import com.pica.cloud.account.account.server.service.PasswordService;
import com.pica.cloud.foundation.utils.utils.EncryptCreateUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Date;

@Service
public class PasswordServiceImpl implements PasswordService {

    @Autowired
    private AccountInfoDetailMapper accountInfoDetailMapper;

    @Autowired
    private AccountLogUtils picaLogUtils;

    @Override
    public void modifyPassword(Integer acctId, String oldPwd, String pwd) {
        AccountInfoEntity entity = accountInfoDetailMapper.selectByPrimaryKey(acctId);
        if (entity.getPassword().equals(EncryptCreateUtil.encrypt(oldPwd))) {
            AccountInfoEntity accountInfoEntity = new AccountInfoEntity();
            accountInfoEntity.setId(acctId);
            accountInfoEntity.setModifiedId(acctId);
            accountInfoEntity.setModifiedTime(new Date());
            accountInfoEntity.setPassword(EncryptCreateUtil.encrypt(pwd));
            accountInfoDetailMapper.updatePasswordByPrimaryKey(accountInfoEntity);
            //密码修改日志
            LogPWDModifyEntity logPWDModifyEntity = AccountLogEntityUtils.getLogPWDModifyEntity(acctId, entity.getMobilePhone(),
                    EncryptCreateUtil.encrypt(oldPwd), EncryptCreateUtil.encrypt(pwd), AccountEnumType.LOG_TYPE_PASSWORD.getCode());
            picaLogUtils.info(logPWDModifyEntity);
        } else {
            throw new AccountException(AccountExceptionType.PICA_PASSWORD_ERROR);
        }
    }

    @Override
    public void forgetPassword(BaseRequest request) {
        AccountInfoEntity entity = accountInfoDetailMapper.selectByMobile(EncryptCreateUtil.encrypt(request.getMobile()));
        if (entity != null) {
            Integer accId = entity.getId();
            AccountInfoEntity accountInfoEntity = new AccountInfoEntity();
            accountInfoEntity.setId(accId);
            accountInfoEntity.setModifiedId(accId);
            accountInfoEntity.setModifiedTime(new Date());
            accountInfoEntity.setPassword(EncryptCreateUtil.encrypt(request.getPassword()));
            accountInfoDetailMapper.updatePasswordByPrimaryKey(accountInfoEntity);

            //密码修改日志
            LogPWDModifyEntity logPWDModifyEntity = AccountLogEntityUtils.getLogPWDModifyEntity(accId, entity.getMobilePhone(),
                    "", EncryptCreateUtil.encrypt(request.getPassword()), AccountEnumType.LOG_TYPE_PASSWORD.getCode());
            picaLogUtils.info(logPWDModifyEntity);
        } else {
            //未注册，请先注册
            throw new AccountException(AccountExceptionType.PICA_NOT_REGISTER);
        }
    }
}
