// Copyright 2016-2101 Pica.
package com.pica.cloud.account.account.server.req;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.NonNull;
import org.hibernate.validator.constraints.NotBlank;

import javax.validation.constraints.Max;
import javax.validation.constraints.Pattern;


/**
 * @Author qinwh
 * @Date 2022/3/1 10:45
 */
@ApiModel
@Data
public class HospitalSaasUserReq {

    @ApiModelProperty("人员id")
    private Long id;

    @ApiModelProperty("姓名")
    @NotBlank(message = "姓名不能为空！")
    @Max(value = 16, message = "长度≤16字符！")
    private String name;

    @ApiModelProperty("机构id")
    private Integer hospitalId;

    @ApiModelProperty("手机号")
    @NotBlank(message = "手机号不能为空！")
    private String mobile;

    @ApiModelProperty("密码")
    @NotBlank(message = "密码不能为空！")
    private String password;

    @ApiModelProperty("备注")
    private String comment;

    @ApiModelProperty("角色id")
    @NotBlank(message = "角色id不能为空！")
    private Long roleId;

}
