package com.pica.cloud.account.account.server.service;

import com.pica.cloud.account.account.server.entity.Doctor;
import com.pica.cloud.account.account.server.req.DoctorReq;

import java.util.List;

/**
 * Created on 2019/9/11 11:01
 * author:crs
 * Description:医生信息接口
 */
public interface DoctorService {

    /**
     * 获取用户信息
     *
     * @param id 用户id
     * @return
     */
    Doctor getDoctorInfo(Integer id);

    /**
     * 修改医生信息
     *
     * @param doctor 待修改数据
     */
    void modifyDoctorInfo(Doctor doctor,Long doctorId);

    int registerWelcome(DoctorReq doctorReq);

    /**
     * 修改医生信息
     *
     * @param id 待修改数据
     */
    void deleteDoctorInfo(Integer id,Long modifyId);

    /**
     * 客服系统新增医生用户
     *
     * @param doctor 新的医生数据
     */
    Integer addDoctorInfo(Doctor doctor,Long doctorId);

    /**
     * doctor绑定微信
     * @param acctId
     * @param unionId
     */
    void bindWeChat(int acctId, String unionId);

    /**
     * doctor解绑微信
     * @param acctId
     */
    void unbindWeChat(int acctId);

    void revertAccts(List<Integer> doctorIds);

    List<Integer> getDoctorsByInnerOrg();
}
