package com.pica.cloud.account.account.server.controller;

import com.alibaba.fastjson.JSONObject;
import com.pica.cloud.account.account.server.entity.AesBean.AesAuthCodeReq;
import com.pica.cloud.account.account.server.entity.EncryptEntity;
import com.pica.cloud.account.account.server.entity.LogLoginAes;
import com.pica.cloud.account.account.server.entity.LoginResult;
import com.pica.cloud.account.account.server.enums.SourceTypeEnum;
import com.pica.cloud.account.account.server.req.BaseRequest;
import com.pica.cloud.account.account.server.req.OneClickLoginReq;
import com.pica.cloud.account.account.server.service.LoginService;
import com.pica.cloud.account.account.server.service.LoginV1Service;
import com.pica.cloud.account.account.server.util.AccountUtils;
import com.pica.cloud.account.account.server.util.CryptoUtil;
import com.pica.cloud.account.account.server.util.RSAUtil;
import com.pica.cloud.foundation.entity.PicaResponse;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(description = "登录注册相关接口 v1.0")
@RestController
@RequestMapping("v1/login")
public class LoginV1Controller extends AccountBaseController {
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private LoginV1Service loginV1Service;

    @Autowired
    private LoginService loginService;

    @ApiOperation(value = "app端手机号码一键登录 v1")
    @PostMapping("one-click")
    public PicaResponse<LoginResult> oneClickLogin(@RequestBody AesAuthCodeReq aesReq) throws Exception {
        EncryptEntity entity = new EncryptEntity();
        entity.setKey(aesReq.getKey());
        entity.setContent(aesReq.getContent());

        OneClickLoginReq req = CryptoUtil.decrypt(entity, OneClickLoginReq.class);
        req.setProductType(super.getProductType());
        req.setSourceType(super.getSourceType());
        req.setLoginIp(super.getIpAddr());
        req.setUserTokenTourist(super.getUserTokenTourist());
        logger.info("one-click req:{}", JSONObject.toJSONString(req));
        LoginResult oneClickLoginResultVo = loginV1Service.oneClickLoginV1(req);
        return PicaResponse.toResponse(oneClickLoginResultVo);
    }

    @ApiOperation(value = "手机号统一校验")
    @PostMapping("/unifiedVerification")
    public PicaResponse unifiedVerification(@RequestBody AesAuthCodeReq req) throws Exception {
        EncryptEntity entity = new EncryptEntity();
        entity.setKey(req.getKey());
        entity.setContent(req.getContent());

        BaseRequest request = CryptoUtil.decrypt(entity, BaseRequest.class);
        request.setSourceType(super.getSourceType());
        logger.info("v1/login/unifiedVerification:{}", JSONObject.toJSONString(request));
        loginV1Service.mobileValidate(request);
        return PicaResponse.toResponse();
    }

    /**
     * 密码登录接口（app、H5、web --> v1）
     *
     * @param authCodeReq
     * @return
     * @throws Exception
     */
    @ApiOperation("密码登录接口")
    @PostMapping("/password")
    public PicaResponse<LoginResult> v1LoginPassword(@RequestBody AesAuthCodeReq authCodeReq) throws Exception {

        EncryptEntity entity = new EncryptEntity();
        entity.setKey(authCodeReq.getKey());
        entity.setContent(authCodeReq.getContent());

        BaseRequest request = CryptoUtil.decrypt(entity, BaseRequest.class);
        request.setProductType(super.getProductType());
        Integer sourceType = super.getSourceType();
        request.setSourceType(sourceType == null ? 0 : sourceType);
        request.setLoginIp(super.getIpAddr());
        request.setUserTokenTourist(super.getUserTokenTourist());
        AccountUtils.checkMobilePhone(request.getMobile());
        AccountUtils.checkPassword(request.getPassword());
        LoginResult login = loginV1Service.v1LoginPassword(request);
        if (SourceTypeEnum.SAAS.getCode().equals(sourceType)) {
            login.setDoctorId("");
        } else {
            login.setUserId(null);
        }
        return PicaResponse.toResponse(login);
    }

}
