package com.pica.cloud.account.account.server.service.impl;

import com.pica.cloud.account.account.server.entity.Doctor;
import com.pica.cloud.account.account.server.mapper.DoctorMapper;
import com.pica.cloud.account.account.server.service.DoctorService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Date;

/**
 * Created on 2019/9/11 11:02
 * author:crs
 * Description:医生相关Service
 */
@Service
public class DoctorServiceImpl implements DoctorService {

    @Autowired
    private DoctorMapper doctorMapper;

    @Override
    public Doctor getDoctorInfo(Integer id) {
        return doctorMapper.selectByPrimaryKey(id);
    }

    @Override
    public void modifyDoctorInfo(Doctor doctor) {
        doctor.setModifyTime(new Date());
        doctorMapper.insertSelective(doctor);
    }
}
