package com.pica.cloud.account.account.server.controller;

import com.pica.cloud.account.account.common.req.circle.CircleAcctInitReq;
import com.pica.cloud.account.account.common.req.circle.DiyAcctInitReq;
import com.pica.cloud.account.account.server.service.CircleAccountService;
import com.pica.cloud.foundation.entity.PicaResponse;
import com.pica.cloud.foundation.service.starter.interceptor.EnabledLoginValidate;
import io.swagger.annotations.Api;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

/**
 * @DESCRIPTOIN:
 * @AUTHOR: joy
 * @DATE:2020/6/21 10:22 上午
 */
@Api(description = "")
@RestController
@RequestMapping("/circle")
public class CircleUserController {
    private Logger logger = LoggerFactory.getLogger(CircleUserController.class);

    @Autowired
    private CircleAccountService circleAccountService;

    @PostMapping("/acct")
    @EnabledLoginValidate
    public PicaResponse<List<Integer>> circleUserInit(@RequestBody CircleAcctInitReq circleAcctInitReq) {
        return PicaResponse.toResponse(circleAccountService.createCircleAccount(circleAcctInitReq));
    }

    @PostMapping("/acct/decryMobile")
    @EnabledLoginValidate
    public PicaResponse<List<Integer>> circleUserInitDecryMobile(@RequestBody DiyAcctInitReq diyAcctInitReq) {
        return PicaResponse.toResponse(circleAccountService.createDiyAccount(diyAcctInitReq));
    }

}
