// Copyright 2016-2101 Pica.
package com.pica.cloud.account.account.server.controller;

import com.alibaba.fastjson.JSON;
import com.pica.cloud.account.account.common.req.HospitalSaasUserListReq;
import com.pica.cloud.account.account.server.req.HospitalSaasUserReq;
import com.pica.cloud.account.account.server.resp.HospitalRoleResp;
import com.pica.cloud.account.account.server.resp.HospitalSaasUserDetailResp;
import com.pica.cloud.account.account.server.resp.HospitalSaasUserEditResp;
import com.pica.cloud.account.account.server.resp.HospitalSaasUserResp;
import com.pica.cloud.account.account.server.service.HospitalSaasRoleService;
import com.pica.cloud.account.account.server.service.HospitalSaasUserService;
import com.pica.cloud.foundation.entity.PicaResponse;
import com.pica.cloud.foundation.service.starter.interceptor.EnabledLoginValidate;
import com.pica.cloud.foundation.utils.entity.PicaUser;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

/**
 * @Author qinwh
 * @Date 2022/3/1 14:45
 */
@Api(description = "机构saas人员资源")
@RestController
@RequestMapping("/saas")
public class HospitalSaasUserController extends AccountBaseController {
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private HospitalSaasUserService hospitalSaasUserService;
    @Autowired
    private HospitalSaasRoleService hospitalSaasRoleService;

    @ApiOperation("机构saas平台人员注册 0失败 1成功")
    @PostMapping(value = "/hospital/register")
    @EnabledLoginValidate
    public PicaResponse<Integer> register(@RequestBody HospitalSaasUserReq req, @RequestHeader("token") String token) {
        logger.info("register: url:/saas/hospital/register. start: {}", JSON.toJSONString(req));
        req.checkInsertParams();
        return PicaResponse.toResponse(hospitalSaasUserService.register(req, super.fetchPicaUser()));
    }

    @ApiOperation("机构saas平台人员注册 0失败 1成功 (密码可为空)")
    @PostMapping(value = "/hospital/registerV2")
    public PicaResponse<Integer> registerV2(@RequestBody HospitalSaasUserReq req) {
        logger.info("register: url:/saas/hospital/registerV2. start: {}", JSON.toJSONString(req));
        req.checkInsertParamsNoPassWord();
        PicaUser user = new PicaUser();
        user.setId(0);
        return PicaResponse.toResponse(hospitalSaasUserService.register(req, user));
    }


    @ApiOperation("机构saas平台人员更新 0失败 1成功")
    @PostMapping(value = "/hospital/upsert")
    @EnabledLoginValidate
    public PicaResponse<Integer> upsert(@RequestBody HospitalSaasUserReq req) {
        logger.info("upsert: url:/saas/hospital/upsert. start: {}", JSON.toJSONString(req));
        return PicaResponse.toResponse(hospitalSaasUserService.upsert(req, super.fetchPicaUser()));
    }

    @ApiOperation("机构saas平台人员更新 0失败 1成功")
    @PostMapping(value = "/hospital/upsertV2")
    public PicaResponse<Integer> upsertV2(@RequestBody HospitalSaasUserReq req) {
        logger.info("upsert: url:/saas/hospital/upsertV2. start: {}", JSON.toJSONString(req));
        PicaUser user = new PicaUser();
        user.setId(0);
        return PicaResponse.toResponse(hospitalSaasUserService.upsert(req, user));
    }

    @ApiOperation("机构saas平台人员列表查询")
    @PostMapping(value = "/hospital/list")
    @EnabledLoginValidate
    public PicaResponse<HospitalSaasUserResp> list(@RequestBody HospitalSaasUserListReq req) {
        logger.info("list: url:/saas/hospital/list. start: {}", JSON.toJSONString(req));
        return PicaResponse.toResponse(hospitalSaasUserService.listByPage(req));
    }

    @ApiOperation("机构saas平台人员数量")
    @PostMapping(value = "/hospital/count")
    public PicaResponse<Integer> count(@RequestBody HospitalSaasUserListReq req) {
        logger.info("list: url:/saas/hospital/count. start: {}", JSON.toJSONString(req));
        return PicaResponse.toResponse(hospitalSaasUserService.count(req));
    }

    @ApiOperation("机构saas平台人员详情更改查询")
    @GetMapping(value = "/hospital/edit/{id}")
    @EnabledLoginValidate
    public PicaResponse<HospitalSaasUserEditResp> edit(@PathVariable("id") Long id) {
        logger.info("edit: url:/saas/hospital/edit/id. start: id={}", id);
        return PicaResponse.toResponse(hospitalSaasUserService.edit(id));
    }

    @ApiOperation("机构saas平台人员删除 0失败 1成功")
    @GetMapping(value = "/hospital/delete")
    @EnabledLoginValidate
    public PicaResponse<Integer> delete(@RequestParam("id") Long id) {
        logger.info("delete: url:/saas/hospital/delete. start: id={}", id);
        return PicaResponse.toResponse(hospitalSaasUserService.delete(id));
    }

    @ApiOperation("机构saas人员详情")
    @GetMapping(value = "/hospital/userDetail")
    @EnabledLoginValidate
    public PicaResponse<HospitalSaasUserDetailResp> userDetail(@RequestHeader("token") String token) {
        return PicaResponse.toResponse(hospitalSaasUserService.userDetail(fetchPicaUser()));
    }

    @ApiOperation("机构saas人员-角色列表")
    @GetMapping(value = "/hospital/listByPage")
    @EnabledLoginValidate
    public PicaResponse<HospitalRoleResp> roleList() {
        return PicaResponse.toResponse(hospitalSaasRoleService.querySaasRoles());
    }

}
