package com.pica.cloud.account.account.server.log;


import com.pica.cloud.account.account.server.entity.LogLoginEntity;
import com.pica.cloud.account.account.server.entity.LogPWDModifyEntity;
import com.pica.cloud.account.account.server.entity.LogUserInfoEntity;
import com.pica.cloud.account.account.server.enums.AccountTypeEnum;

import com.pica.cloud.account.account.server.mapper.LogLoginMapper;
import com.pica.cloud.account.account.server.mapper.LogPWDModifyMapper;
import com.pica.cloud.account.account.server.mapper.LogUserInfoMapper;
import com.pica.cloud.account.account.server.util.BeanUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * Created on 2019/08/27
 * author:crs
 * Description:异步任务处理日志记录
 */
public class AccountLogTask implements Runnable {

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    private LogLoginMapper loginLogMapper;

    private LogPWDModifyMapper logPWDModifyMapper;

    private LogUserInfoMapper logUserInfoMapper;

    /**
     * 日志类型
     */
    private int type;

    /**
     * 日志内容
     */
    private AccountLogEntity picaLogEntity;

    AccountLogTask(AccountLogEntity picaLogEntity) {
        this.picaLogEntity = picaLogEntity;
        type = picaLogEntity.getLogType();
        loginLogMapper = BeanUtil.getBean(LogLoginMapper.class);
        logPWDModifyMapper = BeanUtil.getBean(LogPWDModifyMapper.class);
        logUserInfoMapper = BeanUtil.getBean(LogUserInfoMapper.class);
    }

    @Override
    public void run() {
        try {
            logger.info("log record......");
            if (type == AccountTypeEnum.LOG_TYPE_LOGIN.getCode()) {
                logger.info("login record......");
                loginLogMapper.insertSelective((LogLoginEntity) picaLogEntity);
            } else if (type == AccountTypeEnum.LOG_TYPE_PASSWORD.getCode()) {
                logPWDModifyMapper.insert((LogPWDModifyEntity) picaLogEntity);
            } else if (type == AccountTypeEnum.LOG_TYPE_USER_INFO.getCode()) {
                logUserInfoMapper.insertSelective((LogUserInfoEntity) picaLogEntity);
            }
        } catch (Exception e) {
            logger.error("log record......"+e.getMessage(),e);
        }
    }
}
