package com.pica.cloud.account.account.server.util.captcha;

import org.apache.commons.io.IOUtils;

import java.awt.*;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Random;
import java.util.concurrent.ThreadLocalRandom;

/**
 * @author Laurence Cao
 *
 */
public class CaptchaContext {

    final Random rnd = ThreadLocalRandom.current();
    final int fontCount = 4;

    public int width;
    public int height;
    public float fontSize;
    public boolean showGrid;

    public int gridSize = 1 + rnd.nextInt(10);
    public int rotationAmplitude = rnd.nextInt(10);
    public int scaleAmplitude = 2 * rotationAmplitude;

    public Font font;

    static byte[][] fontDatas = new byte[4][];

    static {
        try {
            InputStream fontStream = CaptchaGenerator.class.getClassLoader().getResourceAsStream("1.ttf");
            fontDatas[0] = IOUtils.toByteArray(fontStream);
            fontStream = CaptchaGenerator.class.getClassLoader().getResourceAsStream("2.ttf");
            fontDatas[1] = IOUtils.toByteArray(fontStream);
            fontStream = CaptchaGenerator.class.getClassLoader().getResourceAsStream("3.ttf");
            fontDatas[2] = IOUtils.toByteArray(fontStream);
            fontStream = CaptchaGenerator.class.getClassLoader().getResourceAsStream("4.ttf");
            fontDatas[3] = IOUtils.toByteArray(fontStream);
        } catch (IOException ex) {
        }
    }

    public CaptchaContext(int width, int height, int fontSize, boolean showGrid) throws FontFormatException, IOException {
        this.width = width;
        this.height = height;
        this.fontSize = fontSize;
        this.showGrid = showGrid;
        int index = ThreadLocalRandom.current().nextInt(0, fontCount);
        this.font = Font.createFont(Font.TRUETYPE_FONT, new ByteArrayInputStream(fontDatas[index]));
    }

    public int rndGridSize() {
        return 1 + rnd.nextInt(10);
    }

    public int rndRotationAmplitude() {
        return rnd.nextInt(10);
    }

    public int rndScaleAmplitude() {
        return rnd.nextInt(20);
    }

    public float rndFontSize() {
        return fontSize + rnd.nextFloat();
    }

}
