package com.pica.cloud.account.account.server.service.impl;

import com.pica.cloud.account.account.server.constants.Constants;
import com.pica.cloud.account.account.server.mapper.DoctorMapper;
import com.pica.cloud.account.account.server.service.TokenService;
import com.pica.cloud.account.account.server.util.TokenUtils;
import com.pica.cloud.foundation.redis.ICacheClient;
import com.pica.cloud.foundation.utils.entity.PicaUser;
import com.pica.cloud.foundation.utils.utils.CommonUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.scheduling.annotation.Async;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.UUID;

import static com.pica.cloud.foundation.utils.utils.json.Object2Map.objectToMapString;

/**
 * Created on 2019/9/11 13:10
 * author:crs
 * Description:获取随机token
 */
@Service
public class TokenServiceImpl implements TokenService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private ICacheClient redisClient;

    @Autowired
    private TokenUtils tokenUtils;

    @Autowired
    @Qualifier("accountThreadPool")
    private ThreadPoolTaskExecutor threadPoolTaskExecutor;

    @Autowired
    private DoctorMapper doctorMapper;

    @Override
    public String getToken(Map<String, Object> headersMap) {
        String mobile = new StringBuilder("9").append(CommonUtil.getRandom(10)).toString();
        headersMap.put(Constants.HEADER_MOBILE, mobile);
        if (!CollectionUtils.isEmpty(headersMap)) {
            PicaUser picaUser = new PicaUser();
            picaUser.setCreated_time(new Date());
            picaUser.setMobile((String) headersMap.get(Constants.HEADER_MOBILE));
            picaUser.setName(Constants.HEADER_USER_TYPE);
            picaUser.setId(0);
            picaUser.setBrowser_ver((String) headersMap.get(Constants.HEADER_BROWSER));
            picaUser.setOs_name((String) headersMap.get(Constants.HEADER_OPERATOR_SYSTEM));
            picaUser.setTerminal_type((String) headersMap.get(Constants.HEADER_TERMINAL_TYPE));
            picaUser.setIp_addr((String) headersMap.get(Constants.HEADER_IP));
            try {
                Map<String, String> map = objectToMapString(Constants.TIME_FORMAT, picaUser, new String[0]);
                map.put(Constants.HEADER_SYS_CODE, Constants.HEADER_SYS_SOURCE);
                map.put(Constants.HEADER_GUEST_ID, UUID.randomUUID().toString().replace("-", "").toUpperCase());
                String token = redisClient.saveToken(map, 21600);
                return token;

            } catch (Exception e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    /**
     * @Description token续时
     * @Author Chongwen.jiang
     * @Date 2020/2/26 14:06
     * @ModifyDate 2020/2/26 14:06
     * @Params [token, sourceType]  sourceType: 1.android  2.ios  3.web  4.h5  5.admin
     * @Return java.lang.String
     */
    @Override
    public void tokenContinueTime(String token, Integer sourceType, Integer seconds) {
        if (StringUtils.isEmpty(token) || null == sourceType) {
            return;
        }

        threadPoolTaskExecutor.execute(() -> {
            if (tokenUtils.tokenContinueTime(token, sourceType, seconds)) {
                logger.info("tokenContinueTime finish");
            }
        });

        return;
    }

    @Override
    public void removeToken(Long timestamp) {
        //new Thread(() -> {
        try {
            Date lastLoginTime = new Date(timestamp);
            for (Integer fromDoctorId = 0; fromDoctorId < 1000412091; fromDoctorId += 10000) {
                logger.info("start remove token: {}", fromDoctorId);
                List<Integer> doctorIdList = doctorMapper.selectIdByParams(fromDoctorId, fromDoctorId + 10000, lastLoginTime);
                if (CollectionUtils.isEmpty(doctorIdList)) {
                    Thread.sleep(2000);
                    continue;
                }
                removeTokenByDoctorIdList(doctorIdList);
                logger.info("remove token done: {} {}", fromDoctorId, doctorIdList.size());
            }
        } catch (Exception ex) {
            // ingnore
        }
        //});
    }

    private void removeTokenByDoctorIdList(List<Integer> doctorIdList) throws Exception {
        for (Integer doctorId : doctorIdList) {
            String key1 = String.format("token-doctor-%d-app", doctorId);
            String key2 = String.format("token-doctor-%d", doctorId);
            String key3 = redisClient.get(key1);
            redisClient.del(key1);
            redisClient.del(key2);
            if (!StringUtils.isEmpty(key3)) {
                redisClient.del(key3);
            }

            Thread.sleep(10);
        }
    }

    @Async
    @Override
    public void removeTokenOfExamTest(Integer beginValue, Integer endValue) {
        Integer num = 0;
        if (beginValue < 200000000) {
            return;
        }
        if (endValue < beginValue) {
            return;
        }

        StringBuilder builder = new StringBuilder("");
        for (int i = beginValue; i < endValue; i++) {
            String key1 = String.format("exam.100006.user.%d.using", i);
            String str = redisClient.get(key1);
            if (!StringUtils.isEmpty(str)) {
                num++;
                builder.append(key1);
                builder.append(":");
                builder.append(str);
                builder.append("|-|-|-|-|");
                redisClient.del(key1);
            }

            if (i % 100 == 0 || (i + 1) == endValue) {
                logger.info(builder.toString());
                builder = new StringBuilder("");
                try {
                    Thread.sleep(1);
                } catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }
        logger.info("removeTokenOfExamTestNum:{}", num);

    }
}
