package com.pica.cloud.account.account.server.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.pica.cloud.account.account.server.entity.Account;
import com.pica.cloud.account.account.server.entity.AccountInfoEntity;
import com.pica.cloud.account.account.server.entity.LogLoginEntity;
import com.pica.cloud.account.account.server.enums.EnumsType;
import com.pica.cloud.account.account.server.enums.ExceptionType;
import com.pica.cloud.account.account.server.log.PicaLogUtils;
import com.pica.cloud.account.account.server.mapper.AccountInfoDetailMapper;
import com.pica.cloud.account.account.server.req.AccountReq;
import com.pica.cloud.account.account.server.req.BaseRequest;
import com.pica.cloud.account.account.server.service.LoginService;
import com.pica.cloud.account.account.server.service.RegisterService;
import com.pica.cloud.account.account.server.util.AccountUtils;
import com.pica.cloud.account.account.server.util.TokenUtils;
import com.pica.cloud.foundation.entity.PicaException;
import com.pica.cloud.foundation.entity.PicaResultCode;
import com.pica.cloud.foundation.redis.ICacheClient;
import com.pica.cloud.foundation.utils.utils.EncryptCreateUtil;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

import java.util.Date;

@Service
public class LoginServiceImpl implements LoginService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private AccountInfoDetailMapper accountInfoDetailMapper;

    @Autowired
    private PicaLogUtils picaLogUtils;

    @Autowired
    private TokenUtils tokenUtils;

    @Autowired
    private RegisterService registerService;

    @Autowired
    @Qualifier("cacheMigrateClient")
    private ICacheClient redisClient;

    @Override
    public String login(BaseRequest request) {
        String mobile = request.getMobile();
        AccountInfoEntity accountInfoEntity = accountInfoDetailMapper.selectByMobile(EncryptCreateUtil.encrypt(mobile));
        if (accountInfoEntity != null) {
            String oldPwd = accountInfoEntity.getPassword();
            String password = request.getPassword();
            if (password.equals(EncryptCreateUtil.dencrypt(oldPwd))) {
                //登陆成功，返回新的token
                Integer id = accountInfoEntity.getId();
                int productType = request.getProductType();
                int sourceType = request.getSourceType();
                Account account = new Account();
                //account.setId(userId.longValue());
                account.setAcctId(id);
                account.setCreatTime(new Date());
                account.setMobilePhone(mobile);
                account.setRegisterSource(sourceType);
                String newToken = tokenUtils.generateToken(account);
                JSONObject jsonObject = new JSONObject();
                jsonObject.put("token", newToken);
                //todo：登陆成功是否要返回用户id
                jsonObject.put("userId", newToken);
                LogLoginEntity entity = new LogLoginEntity();
                entity.setAcctId(id);
                entity.setCreateId(id);
                entity.setCreateTime(new Date());
                entity.setModifyId(id);
                entity.setModifyTime(new Date());
                entity.setDeleteFlag(1);
                entity.setLoginTime(new Date());
                entity.setProductType(productType);
                entity.setSourceType(request.getSourceType());
                entity.setLoginType(EnumsType.LOGIN_REGISTER.getCode());
                entity.setLoginIp(request.getLoginIp());
                entity.setLoginStatus(EnumsType.LOGIN_STATUS_SUCCESS.getCode());
                entity.setLogType(EnumsType.LOG_TYPE_LOGIN.getCode());
                picaLogUtils.info(entity);
                return jsonObject.toJSONString();
            } else {
                logger.info("login failure：" + mobile);
                throw new PicaException(ExceptionType.PICA_PASSWORD_ERROR.getCode(), ExceptionType.PICA_PASSWORD_ERROR.getMessage());
            }
        } else {
            throw new PicaException(ExceptionType.PICA_NOT_REGISTER.getCode(), ExceptionType.PICA_NOT_REGISTER.getMessage());
        }
    }


    @Override
    public String loginAndRegister(BaseRequest baseRequest) {
        String mobile = baseRequest.getMobile();
        int productType = baseRequest.getProductType();
        int sourceType = baseRequest.getSourceType();
        AccountInfoEntity accountInfoEntity = accountInfoDetailMapper.selectByMobile(EncryptCreateUtil.encrypt(mobile));
        if (accountInfoEntity == null) {
            return registerService.register(baseRequest);
        } else {
            Integer id = accountInfoEntity.getId();
            //验证码登陆：只要相同即可成功
            AccountReq accountReq = new AccountReq();
            accountReq.setAuthCode(baseRequest.getSysCode());
            accountReq.setMobilePhone(mobile);
            accountReq.setFlag("0");
            checkAuthCode(accountReq);
            Account account = new Account();
            //account.setId(userId.longValue());
            account.setAcctId(id);
            account.setCreatTime(new Date());
            account.setMobilePhone(mobile);
            account.setRegisterSource(sourceType);
            String newToken = tokenUtils.generateToken(account);
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("token", newToken);
            //todo：登陆成功是否要返回用户id
            LogLoginEntity entity = new LogLoginEntity();
            entity.setAcctId(id);
            entity.setCreateId(id);
            entity.setCreateTime(new Date());
            entity.setModifyId(id);
            entity.setModifyTime(new Date());
            entity.setDeleteFlag(1);
            entity.setLoginTime(new Date());
            entity.setProductType(productType);
            entity.setSourceType(baseRequest.getSourceType());
            entity.setLoginType(EnumsType.LOGIN_REGISTER.getCode());
            entity.setLoginIp(baseRequest.getLoginIp());
            entity.setLoginStatus(EnumsType.LOGIN_STATUS_SUCCESS.getCode());
            entity.setLogType(EnumsType.LOG_TYPE_LOGIN.getCode());
            picaLogUtils.info(entity);
            return jsonObject.toJSONString();
        }
    }

    //校验验证码
    private void checkAuthCode(AccountReq req) {
        String flag = StringUtils.isBlank(req.getFlag()) ? "0" : req.getFlag();

        if (StringUtils.isBlank(req.getAuthCode())) {
            throw new PicaException(PicaResultCode.PARAM_IS_INVALID.code(), "短信验证码错误");
        }

        String authCodeKey = AccountUtils.getAuthCodeKey(req.getMobilePhone(), flag);
        String cacheCode = redisClient.get(authCodeKey);  //从redis获取验证码
        if (StringUtils.isBlank(cacheCode)) {
            throw new PicaException(PicaResultCode.RESULE_DATA_NONE.code(), "短信验证码已过期，请重新获取");
        }
        if (!StringUtils.equals(req.getAuthCode(), cacheCode)) {
            throw new PicaException(PicaResultCode.PARAM_IS_INVALID.code(), "短信验证码错误");
        }
        redisClient.del(authCodeKey);  //清除验证码
    }


}
