package com.pica.cloud.account.account.server.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.pica.cloud.account.account.server.entity.Account;
import com.pica.cloud.account.account.server.entity.AccountInfoEntity;
import com.pica.cloud.account.account.server.entity.AccountUserInfoEntity;
import com.pica.cloud.account.account.server.entity.LogLoginEntity;
import com.pica.cloud.account.account.server.enums.EnumsType;
import com.pica.cloud.account.account.server.enums.ExceptionType;
import com.pica.cloud.account.account.server.log.PicaLogUtils;
import com.pica.cloud.account.account.server.mapper.AccountInfoDetailMapper;
import com.pica.cloud.account.account.server.mapper.AccountUserInfoMapper;
import com.pica.cloud.account.account.server.req.BaseRequest;
import com.pica.cloud.account.account.server.service.RegisterService;
import com.pica.cloud.account.account.server.util.AccountUtils;
import com.pica.cloud.foundation.entity.PicaException;
import com.pica.cloud.foundation.entity.PicaResponse;
import com.pica.cloud.foundation.redis.ICacheClient;
import com.pica.cloud.foundation.utils.utils.EncryptCreateUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

import java.text.SimpleDateFormat;
import java.util.*;

@Service
public class RegisterServiceImpl implements RegisterService {

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private AccountInfoDetailMapper accountInfoDetailMapper;

    @Autowired
    private AccountUserInfoMapper accountUserInfoMapper;

    @Autowired
    @Qualifier("cacheMigrateClient")
    private ICacheClient cacheClient;

    @Autowired
    private PicaLogUtils picaLogUtils;

    @Override
    public String register(BaseRequest baseRequest) {
        String mobile = EncryptCreateUtil.encrypt(baseRequest.getMobile());
        //校验用户是否已经注册
        AccountInfoEntity accountInfoEntity = accountInfoDetailMapper.selectByMobile(mobile);
        if (accountInfoEntity == null) {
            int productType = baseRequest.getProductType();
            int sourceType = baseRequest.getSourceType();
            AccountInfoEntity accountInfo = new AccountInfoEntity();
            accountInfo.setMobilePhone(EncryptCreateUtil.encrypt(baseRequest.getMobile()));
            accountInfo.setPassword(EncryptCreateUtil.encrypt(baseRequest.getPassword()));
            accountInfo.setCreatedTime(new Date());
            accountInfo.setCreatedId(0);
            accountInfo.setModifiedId(0);
            accountInfo.setModifiedTime(new Date());
            accountInfo.setRegTime(new Date());
            accountInfo.setDeleteFlag(1);
            accountInfo.setSex(0);
            accountInfo.setRegisterProduct(productType);
            accountInfo.setRegisterSource(sourceType);
            accountInfoDetailMapper.insertSelective(accountInfo);
            Integer acctId = accountInfo.getId();
            accountInfoDetailMapper.updateCreateInfo(acctId);
            AccountUserInfoEntity accountUserInfoEntity = new AccountUserInfoEntity();
            accountUserInfoEntity.setAcctId(acctId);
            accountUserInfoEntity.setDeleteFlag(1);
            accountUserInfoEntity.setCreateId(acctId);
            accountUserInfoEntity.setModifyId(acctId);
            accountUserInfoEntity.setCreateTime(new Date());
            accountUserInfoEntity.setModifyTime(new Date());
            accountUserInfoMapper.insertSelective(accountUserInfoEntity);
            Integer userId = accountUserInfoEntity.getId();
            Account account = new Account();
            account.setId(userId.longValue());
            account.setAcctId(acctId);
            account.setCreatTime(new Date());
            account.setMobilePhone(mobile);
            account.setRegisterSource(sourceType);
            String newToken = this.generateToken(account);
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("token", newToken);
            jsonObject.put("userId", userId);
            LogLoginEntity entity = new LogLoginEntity();
            entity.setAcctId(acctId);
            entity.setCreateId(acctId);
            entity.setCreateTime(new Date());
            entity.setModifyId(acctId);
            entity.setModifyTime(new Date());
            entity.setDeleteFlag(1);
            entity.setLoginTime(new Date());
            entity.setProductType(productType);
            entity.setSourceType(baseRequest.getSourceType());
            entity.setLoginType(EnumsType.LOGIN_REGISTER.getCode());
            entity.setLoginIp(baseRequest.getLoginIp());
            entity.setLoginStatus(EnumsType.LOGIN_STATUS_SUCCESS.getCode());
            entity.setLogType(EnumsType.LOG_TYPE_LOGIN.getCode());
            picaLogUtils.info(entity);
            return jsonObject.toJSONString();
        } else {
            throw new PicaException(ExceptionType.PICA_ALREADY_REGISTER.getCode(), ExceptionType.PICA_ALREADY_REGISTER.getMessage());
        }
    }

    /**
     * 生成新的token
     *
     * @param account
     * @return
     */
    private String generateToken(Account account) {
        String sourceType = AccountUtils.getSourceType(account.getRegisterSource());
        String newToken = org.apache.commons.lang3.StringUtils.EMPTY;
        try {
            String value = "token-doctor-" + account.getId().toString();
            //生成新token
            int expiredSeconds = 30 * 24 * 60 * 60;//token有效期30天
            newToken = UUID.randomUUID().toString().replace("-", "").toUpperCase();
            String Key = "token-" + newToken;
            //存储token：(token-FF9FCB0D93A642328A01C279701B7607：token-doctor-1)
            cacheClient.set(Key, value, expiredSeconds);
            //存储token：(token-doctor-12345678-app：token-FF9FCB0D93A642328A01C279701B7607)
            cacheClient.set(value + sourceType, Key, expiredSeconds);
            //用户数据放入缓存
            String userData = cacheClient.hget(value, "id");
            if (org.apache.commons.lang3.StringUtils.isEmpty(userData)) {
                Map<String, String> data = new HashMap<>();
                data.put("token", newToken);
                data.put("id", account.getId() + "");
                data.put("acctId", account.getAcctId() + "");
                data.put("mobile", account.getMobilePhone());
                data.put("name", account.getMobilePhone().replaceAll("(\\d{3})\\d{4}(\\w{4})", "$1****$2"));
                data.put("created_time", new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(account.getCreatTime()));
                data.put("sysCode", sourceType);
                Iterator<Map.Entry<String, String>> iterator = data.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry<String, String> map = iterator.next();
                    String key = map.getKey();
                    String valueInfo = map.getValue();
                    //存储token：(token-doctor-1：用户数据)
                    cacheClient.hset(value, key, valueInfo);
                }
            }
        } catch (Exception ex) {
            logger.error("生成token异常：{}" + ex.getMessage(), ex);
        }
        return newToken;
    }
}
