package com.pica.cloud.account.account.server.service.impl;

import com.pica.cloud.account.account.server.entity.*;
import com.pica.cloud.account.account.server.enums.AccountAgreementEnum;
import com.pica.cloud.account.account.server.enums.AccountExceptionEnum;
import com.pica.cloud.account.account.server.enums.AccountTypeEnum;
import com.pica.cloud.account.account.server.exception.AccountException;
import com.pica.cloud.account.account.server.log.AccountLogEntityUtils;
import com.pica.cloud.account.account.server.log.AccountLogUtils;
import com.pica.cloud.account.account.server.mapper.*;
import com.pica.cloud.account.account.server.queue.QueueProducer;
import com.pica.cloud.account.account.server.req.BaseRequest;
import com.pica.cloud.account.account.common.req.OCINRequest;
import com.pica.cloud.account.account.server.service.RegisterService;
import com.pica.cloud.account.account.server.util.AESUtil;
import com.pica.cloud.account.account.server.util.AccountUtils;
import com.pica.cloud.account.account.server.util.ExecutorServiceUtils;
import com.pica.cloud.account.account.server.util.TokenUtils;
import com.pica.cloud.base.doctor.doctor.client.DoctorServiceClient;
import com.pica.cloud.base.doctor.doctor.common.req.PrefectInfoReq;
import com.pica.cloud.foundation.entity.PicaResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Date;
import java.util.concurrent.ExecutorService;

@Service
public class RegisterServiceImpl implements RegisterService {

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private AccountInfoDetailMapper accountInfoDetailMapper;

    @Autowired
    private AccountPatientInfoMapper accountUserInfoMapper;

    @Autowired
    private AccountMapper accountMapper;

    @Autowired
    private AccountLogUtils picaLogUtils;

    @Autowired
    private AccountUtils accountUtils;

    @Autowired
    private TokenUtils tokenUtils;

    @Autowired
    private QueueProducer queueProducer;

    @Autowired
    private AgreementEntityMapper agreementEntityMapper;

    @Autowired
    private AgreementLogEntityMapper agreementLogEntityMapper;

    @Autowired
    private DoctorServiceClient doctorServiceClient;

    @Autowired
    private DoctorMapper doctorMapper;

    /**
     * 1)注册功能：默认未完善信息；
     * 2)注册成功后发送mq消息，让别的服务初始化数据；
     * 3)记录登录日志;
     *
     * @param baseRequest 参数模型
     * @return
     */
    @Override
    public LoginResult register(BaseRequest baseRequest) {
        String mobile = baseRequest.getMobile();
        String mobileEncrypt = AESUtil.encryptV0(mobile);
        AccountInfoEntity accountInfoEntity = accountInfoDetailMapper.selectByMobile(mobileEncrypt);
        if (accountInfoEntity == null) {
            Date currentTime = new Date();
            int productType = baseRequest.getProductType();
            int sourceType = baseRequest.getSourceType();
            String password = baseRequest.getPassword();
            AccountInfoEntity accountInfo = new AccountInfoEntity();
            accountInfo.setMobilePhone(mobileEncrypt);
            if (StringUtils.isEmpty(password)) {
                password = "";
            }
            accountInfo.setPassword(password);
            accountInfo.setCreatedTime(currentTime);
            accountInfo.setCreatedId(0);
            accountInfo.setModifiedId(0);
            accountInfo.setModifiedTime(currentTime);
            accountInfo.setRegTime(currentTime);
            accountInfo.setDeleteFlag(1);
            accountInfo.setSex(0);
            accountInfo.setRegisterProduct(productType);
            accountInfo.setRegisterSource(sourceType);
            accountInfoDetailMapper.insertSelective(accountInfo);
            Integer acctId = accountInfo.getId();
            accountInfoDetailMapper.updateCreateInfo(acctId);
            if (productType == AccountTypeEnum.PRODUCT_TYPE_HEALTH.getCode()) {
                AccountPatientInfoEntity accountPatientInfoEntity = new AccountPatientInfoEntity();
                accountPatientInfoEntity.setAcctId(acctId);
                accountPatientInfoEntity.setDeleteFlag(1);
                accountPatientInfoEntity.setCreateId(acctId);
                accountPatientInfoEntity.setModifyId(acctId);
                accountPatientInfoEntity.setCreateTime(currentTime);
                accountPatientInfoEntity.setModifyTime(currentTime);
                accountUserInfoMapper.insertSelective(accountPatientInfoEntity);
            } else {
                Account account = new Account();
                account.setAcctId(acctId);
                account.setMobilePhone(mobileEncrypt);
                account.setDeleteFlag(1);
                account.setCreatId(0L);
                account.setModifyId(0L);
                account.setCreatTime(currentTime);
                account.setModifyTime(currentTime);
                account.setFirstLoginTime(currentTime);
                account.setLastLoginTime(currentTime);
                account.setPassword(password);
                accountMapper.insertSelective(account);
            }
            Long userId = accountUtils.getUserIdByAcctId(productType, acctId);
            Account account = new Account();
            account.setId(userId);
            account.setAcctId(acctId);
            account.setCreatTime(currentTime);
            account.setMobilePhone(mobile);
            account.setRegisterSource(sourceType);
            String newToken = tokenUtils.generateToken(account);

            LoginResult result = new LoginResult();
            result.setToken(newToken);
            result.setUserId(userId);
            result.setEntireFlag(1);
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            DataOutputStream dos = new DataOutputStream(bos);
            try {
                dos.writeLong(userId);
            } catch (IOException e) {
                e.printStackTrace();
            }
            queueProducer.send(bos.toByteArray());
            LogLoginEntity entity = AccountLogEntityUtils.getLogLoginEntity(acctId, productType, baseRequest.getSourceType(),
                    AccountTypeEnum.LOGIN_REGISTER.getCode(), baseRequest.getLoginIp(), AccountTypeEnum.LOGIN_STATUS_SUCCESS.getCode(),
                    AccountTypeEnum.LOG_TYPE_LOGIN.getCode());
            picaLogUtils.info(entity);
            processAgreement(userId);
            return result;
        } else {
            throw new AccountException(AccountExceptionEnum.PICA_ALREADY_REGISTER);
        }
    }

    /**
     * 长海项目医生自动注册，并完善信息
     *
     * @param request
     */
    @Override
    public PicaResponse ocinRegister(OCINRequest request) {
        String mobile = request.getMobile();
        AccountInfoEntity accountInfoEntity = accountInfoDetailMapper.selectByMobile(mobile);
        if (accountInfoEntity == null) {
            Date currentTime = new Date();
            int productType = request.getProductType();
            int sourceType = request.getSourceType();
            AccountInfoEntity accountInfo = new AccountInfoEntity();
            accountInfo.setMobilePhone(mobile);
            accountInfo.setPassword("");
            accountInfo.setCreatedTime(currentTime);
            accountInfo.setCreatedId(0);
            accountInfo.setModifiedId(0);
            accountInfo.setModifiedTime(currentTime);
            accountInfo.setRegTime(currentTime);
            accountInfo.setDeleteFlag(1);
            accountInfo.setSex(0);
            accountInfo.setRegisterProduct(productType);
            accountInfo.setRegisterSource(sourceType);
            accountInfoDetailMapper.insertSelective(accountInfo);
            Integer acctId = accountInfo.getId();
            accountInfoDetailMapper.updateCreateInfo(acctId);
            //数据插入医生表中
            Account account = new Account();
            account.setAcctId(acctId);
            account.setMobilePhone(mobile);
            account.setDeleteFlag(1);
            account.setCreatId(0L);
            account.setModifyId(0L);
            account.setCreatTime(currentTime);
            account.setModifyTime(currentTime);
            account.setFirstLoginTime(currentTime);
            account.setLastLoginTime(currentTime);
            account.setPassword("");
            accountMapper.insertSelective(account);
            Long userId = accountUtils.getUserIdByAcctId(productType, acctId);
            processAgreement(userId);
            PrefectInfoReq prefectInfoReq = new PrefectInfoReq();
            prefectInfoReq.setDoctorId(userId);
            prefectInfoReq.setHospitalId(request.getHospitalId().longValue());
            prefectInfoReq.setName(request.getName());
            doctorServiceClient.prefectInfo(prefectInfoReq);
            return PicaResponse.toResponse();
        } else {
            Long id = doctorMapper.selectDoctorIdByMobile(mobile);
            return PicaResponse.toResponse(id, AccountExceptionEnum.PICA_ALREADY_REGISTER.getCode(), AccountExceptionEnum.PICA_ALREADY_REGISTER.getCode());
        }
    }

    /**
     * 异步处理协议信息
     * 1)从协议表中获取最新的协议信息；
     * 2)将协议加入到用户协议表中
     */
    private void processAgreement(Long userId) {
        ExecutorService executor = ExecutorServiceUtils.getExecutor();
        executor.submit(() -> {
            //用户协议
            Date currentTime = new Date();
            Integer userVersion = agreementEntityMapper.selectByType(AccountAgreementEnum.USER_AGREEMENT.getCode());
            AgreementLogEntity userAgreementLogEntity = new AgreementLogEntity();
            userAgreementLogEntity.setAgreement_type(AccountAgreementEnum.USER_AGREEMENT.getCode());
            userAgreementLogEntity.setDoctor_id(userId);
            userAgreementLogEntity.setVersion(userVersion.toString());
            userAgreementLogEntity.setCreated_id(userId);
            userAgreementLogEntity.setCreated_time(currentTime);
            userAgreementLogEntity.setModified_id(userId);
            userAgreementLogEntity.setModified_time(currentTime);
            userAgreementLogEntity.setDelete_flag(1);
            agreementLogEntityMapper.insert(userAgreementLogEntity);
            //隐私协议
            Integer privateVersion = agreementEntityMapper.selectByType(AccountAgreementEnum.PRIVACY_AGREEMENT.getCode());
            AgreementLogEntity privateAgreementLogEntity = new AgreementLogEntity();
            privateAgreementLogEntity.setAgreement_type(AccountAgreementEnum.PRIVACY_AGREEMENT.getCode());
            privateAgreementLogEntity.setDoctor_id(userId);
            privateAgreementLogEntity.setVersion(privateVersion.toString());
            privateAgreementLogEntity.setCreated_id(userId);
            privateAgreementLogEntity.setCreated_time(currentTime);
            privateAgreementLogEntity.setModified_id(userId);
            privateAgreementLogEntity.setModified_time(currentTime);
            privateAgreementLogEntity.setDelete_flag(1);
            agreementLogEntityMapper.insert(privateAgreementLogEntity);
        });
    }
}
