package com.pica.cloud.account.account.server.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.pica.cloud.account.account.server.entity.*;
import com.pica.cloud.account.account.server.enums.EnumsType;
import com.pica.cloud.account.account.server.enums.ExceptionType;
import com.pica.cloud.account.account.server.log.PicaLogUtils;
import com.pica.cloud.account.account.server.mapper.AccountInfoDetailMapper;
import com.pica.cloud.account.account.server.mapper.AccountUnionMapper;
import com.pica.cloud.account.account.server.mapper.AccountUserInfoMapper;
import com.pica.cloud.account.account.server.req.AccountReq;
import com.pica.cloud.account.account.server.req.BaseRequest;
import com.pica.cloud.account.account.server.service.LoginService;
import com.pica.cloud.account.account.server.service.RegisterService;
import com.pica.cloud.account.account.server.util.AccountUtils;
import com.pica.cloud.account.account.server.util.TokenUtils;
import com.pica.cloud.foundation.entity.PicaException;
import com.pica.cloud.foundation.entity.PicaResultCode;
import com.pica.cloud.foundation.redis.ICacheClient;
import com.pica.cloud.foundation.utils.utils.EncryptCreateUtil;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

import java.util.Date;

@Service
public class LoginServiceImpl implements LoginService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private AccountInfoDetailMapper accountInfoDetailMapper;

    @Autowired
    private AccountUserInfoMapper accountUserInfoMapper;

    @Autowired
    private AccountUnionMapper accountUnionMapper;

    @Autowired
    private PicaLogUtils picaLogUtils;

    @Autowired
    private TokenUtils tokenUtils;

    @Autowired
    private RegisterService registerService;

    @Autowired
    @Qualifier("cacheMigrateClient")
    private ICacheClient redisClient;

    @Override
    public String login(BaseRequest request) {
        String mobile = request.getMobile();
        AccountInfoEntity accountInfoEntity = accountInfoDetailMapper.selectByMobile(EncryptCreateUtil.encrypt(mobile));
        if (accountInfoEntity != null) {
            String oldPwd = accountInfoEntity.getPassword();
            String password = request.getPassword();
            if (password.equals(EncryptCreateUtil.dencrypt(oldPwd))) {
                //登陆成功，返回新的token
                //通过账户id查询用户id
                Date currentTime = new Date();
                Integer acctId = accountInfoEntity.getId();
                AccountUserInfoEntity accountUserInfoEntity = accountUserInfoMapper.selectByAcctId(acctId);
                int productType = request.getProductType();
                int sourceType = request.getSourceType();
                Account account = new Account();
                account.setId(accountUserInfoEntity.getId().longValue());
                account.setAcctId(acctId);
                account.setCreatTime(currentTime);
                account.setMobilePhone(mobile);
                account.setRegisterSource(sourceType);
                String newToken = tokenUtils.generateToken(account);
                JSONObject jsonObject = new JSONObject();
                jsonObject.put("token", newToken);
                jsonObject.put("userId", accountUserInfoEntity.getId().longValue());
                LogLoginEntity entity = new LogLoginEntity();
                entity.setAcctId(acctId);
                entity.setCreateId(acctId);
                entity.setCreateTime(currentTime);
                entity.setModifyId(acctId);
                entity.setModifyTime(currentTime);
                entity.setDeleteFlag(1);
                entity.setLoginTime(currentTime);
                entity.setProductType(productType);
                entity.setSourceType(request.getSourceType());
                entity.setLoginType(EnumsType.LOGIN_REGISTER.getCode());
                entity.setLoginIp(request.getLoginIp());
                entity.setLoginStatus(EnumsType.LOGIN_STATUS_SUCCESS.getCode());
                entity.setLogType(EnumsType.LOG_TYPE_LOGIN.getCode());
                picaLogUtils.info(entity);
                return jsonObject.toJSONString();
            } else {
                logger.info("login failure：" + mobile);
                throw new PicaException(ExceptionType.PICA_PASSWORD_ERROR.getCode(), ExceptionType.PICA_PASSWORD_ERROR.getMessage());
            }
        } else {
            throw new PicaException(ExceptionType.PICA_NOT_REGISTER.getCode(), ExceptionType.PICA_NOT_REGISTER.getMessage());
        }
    }


    @Override
    public String loginAndRegister(BaseRequest baseRequest) {
        String mobile = baseRequest.getMobile();
        int productType = baseRequest.getProductType();
        int sourceType = baseRequest.getSourceType();
        AccountInfoEntity accountInfoEntity = accountInfoDetailMapper.selectByMobile(EncryptCreateUtil.encrypt(mobile));
        if (accountInfoEntity == null) {
            return registerService.register(baseRequest);
        } else {
            Date currentTime = new Date();
            Integer acctId = accountInfoEntity.getId();
            AccountUserInfoEntity accountUserInfoEntity = accountUserInfoMapper.selectByAcctId(acctId);
            //验证码登陆：只要相同即可成功
            AccountReq accountReq = new AccountReq();
            accountReq.setAuthCode(baseRequest.getSysCode());
            accountReq.setMobilePhone(mobile);
            accountReq.setFlag("0");
            checkAuthCode(accountReq);
            Account account = new Account();
            account.setId(accountUserInfoEntity.getId().longValue());
            account.setAcctId(acctId);
            account.setCreatTime(currentTime);
            account.setMobilePhone(mobile);
            account.setRegisterSource(sourceType);
            String newToken = tokenUtils.generateToken(account);
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("token", newToken);
            jsonObject.put("userId", accountUserInfoEntity.getId().longValue());
            LogLoginEntity entity = new LogLoginEntity();
            entity.setAcctId(acctId);
            entity.setCreateId(acctId);
            entity.setCreateTime(currentTime);
            entity.setModifyId(acctId);
            entity.setModifyTime(currentTime);
            entity.setDeleteFlag(1);
            entity.setLoginTime(currentTime);
            entity.setProductType(productType);
            entity.setSourceType(baseRequest.getSourceType());
            entity.setLoginType(EnumsType.LOGIN_REGISTER.getCode());
            entity.setLoginIp(baseRequest.getLoginIp());
            entity.setLoginStatus(EnumsType.LOGIN_STATUS_SUCCESS.getCode());
            entity.setLogType(EnumsType.LOG_TYPE_LOGIN.getCode());
            picaLogUtils.info(entity);
            return jsonObject.toJSONString();
        }
    }

    @Override
    public String loginByWeChat(BaseRequest request) {
        //todo：微信登录获取信息
        WeChatEntity weChatEntity = null;
        String unionId = weChatEntity.getUnionid();
        //账号逻辑处理
        Date currentTime = new Date();
        AccountInfoEntity entity = new AccountInfoEntity();
        entity.setCreatedTime(currentTime);
        entity.setCreatedId(0);
        entity.setModifiedId(0);
        entity.setModifiedTime(currentTime);
        entity.setRegTime(currentTime);
        entity.setDeleteFlag(1);
        entity.setSex(0);
        entity.setRegisterProduct(request.getProductType());
        entity.setRegisterSource(request.getSourceType());
        accountInfoDetailMapper.insertSelective(entity);
        Integer acctId = entity.getId();
        //联合登录逻辑的处理
        AccountUnionEntity accountUnionEntity = new AccountUnionEntity();
        accountUnionEntity.setAcctId(acctId.longValue());
        accountUnionEntity.setCreatedId(acctId);
        accountUnionEntity.setModifiedId(acctId);
        accountUnionEntity.setUnionId(unionId);
        accountUnionEntity.setUnionType(EnumsType.UNION_LOGIN_WE_CHAT.getCode());
        accountUnionEntity.setModifiedTime(currentTime);
        accountUnionEntity.setCreatedTime(currentTime);
        accountUnionMapper.insertSelective(accountUnionEntity);
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("bindFlag", EnumsType.BIND_STATUS_FAILURE.getCode());
        jsonObject.put("unionId", unionId);
        return jsonObject.toJSONString();
    }

    @Override
    public void unbindWeChat(Integer acctId) {
        accountUnionMapper.updateUnbindByAcctId(acctId);

    }

    //校验验证码
    private void checkAuthCode(AccountReq req) {
        String flag = StringUtils.isBlank(req.getFlag()) ? "0" : req.getFlag();

        if (StringUtils.isBlank(req.getAuthCode())) {
            throw new PicaException(PicaResultCode.PARAM_IS_INVALID.code(), "短信验证码错误");
        }

        String authCodeKey = AccountUtils.getAuthCodeKey(req.getMobilePhone(), flag);
        String cacheCode = redisClient.get(authCodeKey);  //从redis获取验证码
        if (StringUtils.isBlank(cacheCode)) {
            throw new PicaException(PicaResultCode.RESULE_DATA_NONE.code(), "短信验证码已过期，请重新获取");
        }
        if (!StringUtils.equals(req.getAuthCode(), cacheCode)) {
            throw new PicaException(PicaResultCode.PARAM_IS_INVALID.code(), "短信验证码错误");
        }
        redisClient.del(authCodeKey);  //清除验证码
    }


}
