package com.pica.cloud.account.account.server.service.impl;

import com.pica.cloud.account.account.server.entity.AccountInfoEntity;
import com.pica.cloud.account.account.server.mapper.AccountInfoDetailMapper;
import com.pica.cloud.account.account.server.service.ModifyMobileService;
import com.pica.cloud.foundation.utils.utils.EncryptCreateUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Date;

@Service
public class ModifyMobileServiceImpl implements ModifyMobileService {

    @Autowired
    private AccountInfoDetailMapper accountInfoDetailMapper;

    @Override
    public void modify(Integer acctId, String mobile) {
        AccountInfoEntity accountInfoEntity = new AccountInfoEntity();
        accountInfoEntity.setId(acctId);
        accountInfoEntity.setModifiedId(acctId);
        accountInfoEntity.setModifiedTime(new Date());
        accountInfoEntity.setMobilePhone(EncryptCreateUtil.encrypt(mobile));
        accountInfoDetailMapper.updateMobileByPrimaryKey(accountInfoEntity);
    }
}
