package com.pica.cloud.account.account.server.util;

import com.pica.cloud.account.account.server.entity.Account;
import com.pica.cloud.foundation.redis.ICacheClient;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.UUID;

/**
 * Token工具类
 */
@Component
public class TokenUtils {

    @Autowired
    @Qualifier("cacheMigrateClient")
    private ICacheClient cacheClient;


    /**
     * 校验token的状态
     *
     * @param token
     * @return
     */
    public boolean checkTokenStatus(String token) {
        String str = cacheClient.get("token-" + token);
        return StringUtils.isBlank(str);
    }


    /**
     * 生成随机token
     *
     * @param account
     * @return
     */
    public String generateToken(Account account) {
        //判断用户终端类型
        String sourceType = AccountUtils.getSourceType(account.getRegisterSource());
        String newToken = StringUtils.EMPTY;
        //用户唯一key
        String tokenDoctorId = "token-doctor-" + account.getId().toString();
        //清除旧token对应的用户id
        String oldToken = cacheClient.get(tokenDoctorId + "-" + sourceType);
        if (StringUtils.isNoneBlank(oldToken)) {
            cacheClient.del(oldToken);
        }
        //生成新的token,并和用户唯一key绑定
        newToken = UUID.randomUUID().toString().replace("-", "").toUpperCase();
        int expiredSeconds = 30 * 24 * 60 * 60;
        cacheClient.set("token-" + newToken, tokenDoctorId, expiredSeconds);
        //存储当前登录终端对应的token
        cacheClient.set(tokenDoctorId + "-" + sourceType, "token-" + newToken, expiredSeconds);
        String userData = cacheClient.hget(tokenDoctorId, "id");
        if (StringUtils.isEmpty(userData)) {
            Map<String, String> map = new HashMap<>();
            map.put("token", newToken);
            map.put("id", account.getId() + "");
            map.put("mobile", account.getMobilePhone());
            map.put("name", account.getMobilePhone().replaceAll("(\\d{3})\\d{4}(\\w{4})", "$1****$2"));
            map.put("created_time", new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(account.getCreatTime()));
            map.put("sysCode", sourceType);
            Iterator<Map.Entry<String, String>> iterator = map.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<String, String> mapData = iterator.next();
                String key = mapData.getKey();
                String valueInfo = mapData.getValue();
                //存储token：(token-doctor-1：用户数据)
                cacheClient.hset(tokenDoctorId, key, valueInfo);
            }
        }
        return newToken;
    }
}
