package com.pica.cloud.account.account.client;

import com.pica.cloud.account.account.common.req.AcctPatInfoReq;
import com.pica.cloud.foundation.entity.PicaResponse;
import org.springframework.cloud.netflix.feign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

@FeignClient(name = "13201-pica-cloud-account")
public interface PatientInfoClient {

    @GetMapping(value = "/account/patient/unionId/{patientId}")
    PicaResponse<String> getUnionIdByPatientId(@PathVariable("patientId") Integer patientId);

    @PostMapping(value = "/account/patient/acct/info")
    PicaResponse postUserInfo(@RequestBody AcctPatInfoReq infoReq);

}
