package com.pica.cloud.account.account.server.util.captcha;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.Base64;

/**
 * @author Laurence Cao
 *
 */
public class CaptchaToken {

    /**
     * 代表此验证码的唯一标识符，超时和一次使用均会失效
     */
    protected String token;

    /**
     * 代表此验证码的实际图片，以字节码方式提供
     */
    @JsonIgnore
    protected byte[] buf;

    /**
     * 原始随机字符串
     */
    @JsonIgnore
    protected String origin;

    /**
     * base64编码的图片
     */
    protected String content;

    public String getToken() {
        return token;
    }

    public void setToken(String token) {
        this.token = token;
    }

    public byte[] getBuf() {
        return buf;
    }

    public void setBuf(byte[] buf) {
        this.buf = buf;
        setContent(Base64.getEncoder().encodeToString(this.buf));
    }

    public String getContent() {
        return content;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public String getOrigin() {
        return origin;
    }

    public void setOrigin(String origin) {
        this.origin = origin;
    }
}
