package com.pica.cloud.account.account.server.model;

import com.alibaba.fastjson.JSONObject;
import com.pica.cloud.account.account.server.entity.LogLoginOnekey;
import com.pica.cloud.account.account.server.entity.MobileDataEntity;
import com.pica.cloud.account.account.server.entity.QueryMobileEntity;
import com.pica.cloud.account.account.server.mapper.LogLoginOnekeyMapper;
import com.pica.cloud.account.account.server.util.AESUtil;
import com.pica.cloud.account.account.server.util.HttpUtil;
import com.pica.cloud.account.account.server.util.MD5;
import com.pica.cloud.account.account.server.util.RSAUtil;
import com.pica.cloud.account.account.server.util.SignUtils;
import com.pica.cloud.foundation.entity.PicaException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Component;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;

/**
 * @program: pica-cloud-account
 * @description:
 * @author: wfy
 * @create: 2020-02-24 13:57
 */
@Component
public class OneClickProcessor {
    private static final String DEFAULT_ENCRYPT_TYPE = "0";

    private Logger logger = LoggerFactory.getLogger(this.getClass());
    //手机号加解密方式 0 AES 1 RSA , 可以不传，不传则手机号解密直接使用AES解密
    private String aesEncryptType = DEFAULT_ENCRYPT_TYPE;
    private String rsaEncryptType = "1";
    private String encryptType = DEFAULT_ENCRYPT_TYPE;
    //创建应用时填入的rsa公钥对应的私钥字符串
    public static final String privateKey = "";
    @Value("${shanyan.url.mobilequery}")
    private String mobileQueryUrl;
    @Value("${shanyan.android.appId}")
    private String androidAppId;
    @Value("${shanyan.android.appKey}")
    private String androidAppKey;
    @Value("${shanyan.ios.appId}")
    private String iosAppId;
    @Value("${shanyan.ios.appKey}")
    private String iosAppKey;

    @Autowired
    private LogLoginOnekeyMapper logLoginOnekeyMapper;

    public QueryMobileEntity tokenExchangeMobile(String token, Integer type) {
        if (type == null) {
            return null;
        }
        String appId;
        String appKey;
        if (type.equals(1)) {
            appId = androidAppId;
            appKey = androidAppKey;
        } else if (type.equals(2)) {
            appId = iosAppId;
            appKey = iosAppKey;
        } else {
            return null;
        }
        //从SDK获取的token参数
        QueryMobileEntity queryMobileEntity = null;
        try {
            Map<String, String> params = new HashMap<>();
            params.put("token", token);
            params.put("appId", appId);
            params.put("encryptType", encryptType);//可以不传，不传则解密直接使用AES解密
            params.put("sign", SignUtils.getSign(params, appKey));
            queryMobileEntity = HttpUtil.postForm(mobileQueryUrl, params, QueryMobileEntity.class);
            if (null != queryMobileEntity) {
                String code = queryMobileEntity.getCode();     //返回码 200000为成功
                if ("200000".equals(code)) {
                    MobileDataEntity mobileDataEntity = queryMobileEntity.getData();
                    String mobile = mobileDataEntity.getMobileName();
                    if (aesEncryptType.equals(encryptType)) {
                        String key = MD5.getMD5Code(appKey);
                        mobile = AESUtil.decrypt(mobile, key.substring(0, 16), key.substring(16));
                    } else if (rsaEncryptType.equals(encryptType)) {
                        mobile = RSAUtil.decryptByPrivateKeyForLongStr(mobile, privateKey);
                    }
                    queryMobileEntity.setMobile(mobile);
                }
            }
        } catch (Exception e) {
            logger.error(e.getMessage());
        }
        return queryMobileEntity;
    }

    @Async
    public void savelogLoginOnekey(QueryMobileEntity queryMobileEntity, Integer type,Integer logLoginId) {
        LogLoginOnekey l = new LogLoginOnekey();
        l.setDeviceType(type.byteValue());
        MobileDataEntity data = queryMobileEntity.getData();
        l.setFanqizha(data.getFanqizha().byteValue());
        l.setTradeNo(data.getTradeNo());
        l.setMobile(AESUtil.encryptV0(data.getMobileName()));
        l.setLogLoginId(logLoginId);
        l.setInfo(JSONObject.toJSONString(queryMobileEntity));
        Date d = new Date();
        l.setCreateId(-1);
        l.setCreateTime(d);
        l.setModifyId(-1);
        l.setModifyTime(d);
        logLoginOnekeyMapper.insertSelective(l);
    }
}
